% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{caption}
\alias{caption}
\alias{caption<-}
\alias{set_caption}
\title{Caption}
\usage{
caption(ht)
caption(ht) <- value
set_caption(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector. Set to \code{NA} to reset to the default, which is
\code{NA}.}
}
\value{
For \code{caption}, the \code{caption} property.
For \code{set_caption}, the modified huxtable.
}
\description{
Functions to get or set the table-level \emph{caption} property of a huxtable.
}
\details{
Captions are not escaped. See the example for a workaround.
}
\examples{

caption(jams) <-  "An example table"
caption(jams)
jams

# escape caption characters:
caption(jams) <- sanitize(
      "Make $$$ with jam",
      type = "latex")
}
\seealso{
\code{\link[=caption_pos]{caption_pos()}}
}
