% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{label}
\alias{label}
\alias{label<-}
\alias{set_label}
\title{Table label}
\usage{
label(ht)
label(ht) <- value
set_label(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector to be used as a table label in LaTeX, or as an ID for the table in HTML. Set to \code{NA} to reset to the default, which is
\code{NA}.}
}
\value{
For \code{label}, the \code{label} property.
For \code{set_label}, the modified huxtable.
}
\description{
Functions to get or set the table-level \emph{table label} property of a huxtable.
}
\details{
LaTeX table labels typically start with \code{"tab:"}.

If you use \href{http://bookdown.org}{bookdown}, and set a label on your table,
the caption will automatically be prefixed with \code{(#label)}. You can then
refer to the table using \code{@ref(label)}. \code{label} needs to start with \code{"tab:"}; if it doesn't,
the \code{"tab"} prefix will be added automatically.
}
\examples{

orig <- label(jams)
label(jams) <-  "tab:mytable"
label(jams)

label(jams) <- orig
}
