% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.R
\name{hwefit}
\alias{hwefit}
\title{Equilibrium and random mating estimation and testing for many loci.}
\usage{
hwefit(
  nmat,
  type = c("ustat", "mle", "rm", "nodr", "boot"),
  effdf = TRUE,
  thresh = 3,
  nboot = 2000,
  verbose = TRUE
)
}
\arguments{
\item{nmat}{A matrix of counts. The rows index the loci and the columns
index the genotypes. So \code{nmat[i, j]} is the number of individuals
that have genotype \code{j-1} at locus \code{i}. The ploidy is
assumed to be \code{ncol(nmat)-1}.}

\item{type}{The method to use:
\describe{
\item{\code{"ustat"}}{U-statistic approach to test for equilibrium and
estimate double reduction rates given equilibrium. The default.
See \code{\link{hweustat}()}.}
\item{\code{"mle"}}{Maximum likelihood estimation and testing. Only
supported for ploidies less than or equal to 10.
See \code{\link{hwelike}()}.}
\item{\code{"rm"}}{Testing random mating, and estimating gamete
frequencies given random mating. See \code{\link{rmlike}()}.}
\item{\code{"nodr"}}{Testing equilibrium given no double reduction.
See \code{\link{hwenodr}()}.}
\item{\code{"boot"}}{Bootstrap approach to test for equilibrium.
See \code{\link{hweboot}()}.}
}}

\item{effdf}{A logical. Should we use the effective degrees of freedom?
Only applicable if \code{type = "mle"} or \code{type = "ustat"}.}

\item{thresh}{A non-negative numeric. The threshold for aggregating
genotypes. Only applicable if \code{type = "mle"},
\code{type = "ustat"}, or \code{type = "rm"}.}

\item{nboot}{The number of bootstrap iterations to use if
\code{type = "boot"}.}

\item{verbose}{Should we print more (\code{TRUE}) or less (\code{FALSE})?}
}
\value{
A data frame. The columns of which can are described in
\code{\link{hwelike}()}, \code{\link{hweustat}()},
\code{\link{rmlike}()}, or \code{\link{hwenodr}()}.
}
\description{
Estimates and tests for either equilibrium or random mating  across many loci
using \code{\link{hwelike}()}, \code{\link{hweustat}()},
\code{\link{rmlike}()}, \code{\link{hwenodr}()}, or \code{\link{hweboot}()}.
}
\details{
We provide parallelization support through the \link[future]{future}
package.
}
\examples{
## Generate random data
set.seed(5)
ploidy <- 4
nloc <- 100
size <- 1000
r <- 0.25
alpha <- 1/12
qvec <- hwefreq(r = r, alpha = alpha, ploidy = ploidy)
nmat <- t(rmultinom(n = nloc, size = size, prob = qvec))

## Run the analysis in parallel on the local computer with two workers
future::plan(future::multisession, workers = 2)
hout <- hwefit(nmat = nmat, type = "ustat")

## Shut down parallel workers
future::plan("sequential")

## Show that p-values are uniform

## QQ-plot on -log10 scale
qqpvalue(pvals = hout$p_hwe, method = "base")

## Kolmogorov-Smirnov Test
stats::ks.test(hout$p_hwe, "qunif")

## Can control for Type I error
mean(hout$p_hwe < 0.05)

## Consistent estimate for alpha
alpha
mean(hout$alpha1)

}
\author{
David Gerard
}
