% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_gl_alt}
\alias{gibbs_gl_alt}
\title{Gibbs sampler under the alternative of non-random mating using genotype
log-likelihoods.}
\usage{
gibbs_gl_alt(
  gl,
  beta,
  B = 10000L,
  T = 1000L,
  more = FALSE,
  lg = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{gl}{The matrix of genotype log-likelihoods. The columns index the
dosages and the rows index the individuals. \code{gl[i,j]} is the
genotype log-likelihood for individual i at dosage j. It is assumed
that natural log is used.}

\item{beta}{The concentration hyperparameter for the genotype frequencies.}

\item{B}{The number of sampling iterations.}

\item{T}{The number of burn-in iterations.}

\item{more}{A logical. Should we also return posterior draws (\code{TRUE})
or not (\code{FALSE}).}

\item{lg}{Should we return the log marginal likelihood (true) or not
(false).}

\item{verbose}{A logical. Should we print the progress?}
}
\value{
A list with some or all of the following elements
\itemize{
\item{\code{mx}: The estimate of the marginal likelihood}
}
}
\description{
Gibbs sampler under the alternative of non-random mating using genotype
log-likelihoods.
}
\examples{
set.seed(1)
ploidy <- 8

## Simulate under the alternative
q <- stats::runif(ploidy + 1)
q <- q / sum(q)
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
gl <- simgl(nvec)

gibbs_gl_alt(gl = gl, beta = rep(1, ploidy + 1), lg = TRUE)

}
\author{
David Gerard
}
