% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_agg_table.R
\name{agg_table}
\alias{agg_table}
\title{Aggregates a data frame to a larger time period}
\usage{
agg_table(
  x,
  col_name,
  fun,
  period,
  out_name = NULL,
  allow_na = 0,
  start_month = 1,
  end_month = 12
)
}
\arguments{
\item{x}{data frame with class \code{Date} or \code{POSIXct} in the first column.}

\item{col_name}{string with column(s) name(s) to aggregate.}

\item{fun}{string with supported aggregation function name (one per \option{col_name}):
\option{mean}, \option{min}, \option{max}, \option{sum}, \option{last} or \option{first}.}

\item{period}{string with the aggregation time-step: \option{hourly}, \option{daily},
\option{monthly}, \option{annually} or \option{climatic}. \bold{NOTE}: the \option{climatic}
option returns the all series annual statistics (\option{fun}).}

\item{out_name}{optional. String with the output column(s) name(s). Default values coerce the original
name plus the \option{fun} argument (e.g.: \code{tair_max}).}

\item{allow_na}{optional. Numeric value with the maximum allowed number of \code{NA_real_}
values. By default the function will not tolerate any \code{NA_real_} (and will return
\code{NA_real_} instead).}

\item{start_month}{optional. Numeric value defining the first month of the annual
period (it just make sense if \option{period} is either \option{annually} or
\option{climatic}). Default sets to 1 (January). \bold{NOTE}: keep in mind that if you
choose \option{climatic} as period you have to round off a complete year (e.g.:
\code{..., start_month = 6, end_month = 5, ...})}

\item{end_month}{optional. Numeric value defining the last month of the annual period
(it just make sense if \option{period} is either \option{annually} or
\option{climatic}). Default sets to 12 (December). \bold{NOTE}: keep in mind that if
you choose \option{climatic} as period you have to round off a complete year (e.g.:
\code{..., start_month = 6, end_month = 5, ...})}
}
\value{
A data frame with the Date and the aggregated variable(s).
}
\description{
Aggregates a data frame to a larger time period
}
\examples{

# set path to file
path <- system.file('extdata', 'snih_qd_guido.xlsx',
         package = 'hydrotoolbox')

# read and load daily streamflow with default column name
guido_qd <- read_snih(path = path, by = 'day', out_name = 'q(m3/s)')

# aggregate daily to monthly discharge
guido_q_month <- agg_table(x = guido_qd, col_name = 'q(m3/s)',
                          fun = 'mean', period = 'monthly',
                          out_name = 'qm(m3/s)')

# suppose that we are interested on getting the annual maximum
# daily mean discharge for every hydrological year (since this
# station is located at the Mendoza River Basin ~32.9º S, we will
# consider that annual period starts on July)
guido_q_annual <- agg_table(x = guido_qd, col_name = 'q(m3/s)',
                            fun = 'max', period = 'annually',
                            out_name = 'qmax(m3/s)',
                            start_month = 7, end_month = 6)

# now we want the mean, maximum and minimum monthly discharges
guido_q_stats <- agg_table(x = guido_qd, col_name = rep('q(m3/s)', 3),
                           fun = c('mean', 'max', 'min'),
                           period = 'monthly')


}
