% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_read_mnemos.R
\name{read_mnemos}
\alias{read_mnemos}
\title{Reads data provided by MNEMOS software (SNIH - Argentina)}
\usage{
read_mnemos(
  path,
  by = "none",
  out_name = NULL,
  sheet = NULL,
  skip = 3,
  get_sheet = FALSE
)
}
\arguments{
\item{path}{path to the xlsx file.}

\item{by}{string with the time step of the series (e.g.: \code{'month', 'day', '6 hour',
'3 hour', '1 hour', '15 min' }). If you set it as \code{'none'}, the function will ignore
automatic gap filling.}

\item{out_name}{optional. String vector with user defined variable(s) column(s) name(s).}

\item{sheet}{optional. Sheet to read. Either a string (the name of a sheet), or an integer
(the position of the sheet). If neither argument specifies the sheet, defaults to the
first sheet.}

\item{skip}{optional. Minimum number of rows to skip before reading anything, be it column
names or data. Leading empty rows are automatically skipped, so this is a lower bound.}

\item{get_sheet}{logical indicating whether you want to print available variables (\code{TRUE})
in every file sheet or not.}
}
\value{
A data frame with the data inside the specified sheet. Gaps between dates are
 filled with \code{NA_real_} and duplicated rows are eliminated automatically. In case
 you set \code{get_sheet = TRUE} the function will return a \code{list} with the variables
 inside each sheet.
}
\description{
Reads xlsx files generated with MNEMOS software.
}
\examples{

# list mnemos files
list.files( system.file('extdata', package = 'hydrotoolbox'), pattern = 'mnemos' )

# set path
path <- system.file('extdata', 'mnemos_guido.xlsx',  package = 'hydrotoolbox')

# we can see which variables are inside the sheet's file
read_mnemos(path = path, get_sheet = TRUE)

# now we want to read the maximum temperature
tmax_guido <- read_mnemos(path = path, by = 'day',
                          out_name = 'tmax(ºC)', sheet = '11413-016')



}
