% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_hdr_envi.R
\name{read_hdr_envi}
\alias{read_hdr_envi}
\title{Read Metadata from an ENVI Header File}
\usage{
read_hdr_envi(path, hFOV = NULL, vFOV = NULL, height = NULL)
}
\arguments{
\item{path}{A character giving the path for the header file (.hdr).}

\item{hFOV}{(Optional, numeric) The horizontal Field Of View (in degrees) of
the sensor. Note: this is used to calculate the spatial extent. See Details.}

\item{vFOV}{(Optional, numeric) The vertical Field Of View (in degrees) of
the sensor. Note: this is used to calculate the spatial extent. See Details.}

\item{height}{(Optional, numeric) The flight altitude (in meters). Note:
this is be used to calculate the spatial extent. See Details.}
}
\value{
A \code{list} of the following:
\describe{
\item{dim}{ An integer vector with the dimensions of the image: number of
columns (x), rows (y) and layers (spectral bands).}
\item{wavelength}{ A numeric vector of the wavelength registered, the same
length as the number of layers (spectral bands).}
\item{gain}{ A numeric vector of gain values of each spectral band.}
\item{irradiance}{ A numeric vector of the solar irradiance values
registered by the corresponding sensor at each spectral band. Please
check the unit (usually W/(m^2 µm sr)) with the manufacturer
specifications.}
\item{coordinates}{ A numeric matrix with the geographic coordinates (xy)
registered by the sensor at each spectral band.}
\item{extents}{ A four-column numeric matrix with the spatial extents
(xmin, xmax, ymin, ymax), in UTM, of each spectral band. This is
\code{NULL} if the optional arguments are not passed.}
\item{CRS}{ The Coordinate Reference System of the spatial extents.
This is \code{NULL} if the optional arguments are not passed.}
}
}
\description{
The ENVI image files are accompanied by an ASCII header file (.hdr format)
containing the metadata of the image, such as number of samples (rows),
lines (columns), number of spectral bands, wavelength, byte order,
data type, gain values (if available), irradiance (if available),
coordinates etc. This file is necessary to properly read the image data.
}
\details{
The geographical coordinates (xy) registered in the header file
are automatically retrieved. Please be aware that \code{read_hdr_envi}
uses the string "gps" to search this field in the header file. If necessary,
rename this field in the header file.

If the arguments \code{hFOV}, \code{vFOV} and
\code{height} are passed, \code{read_hdr_envi} will automatically compute
the UTM zone and the spatial extent, and set up the coordinate reference
system.
}
\examples{
# Example 1
path_hdr <- system.file('exdata', 'obory.hdr', package = 'hyperbrick')
readLines(path_hdr)
read_hdr_envi(path_hdr)

# Example 2 - set up the CRS to UTM and retrieve extents
read_hdr_envi(path_hdr, hFOV = 36.8, vFOV = 36.8, height = 45)

}
\seealso{
\code{\link[=buildBrick]{buildBrick()}}
}
