% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerBand.R
\name{registerBand}
\alias{registerBand}
\title{Single Band-to-Band Registration (Translation)}
\usage{
registerBand(slave, master, ncells = 24, orient = 8)
}
\arguments{
\item{slave}{An object of class \code{RasterLayer} (from package
\link{raster}).}

\item{master}{An object of class \code{RasterLayer} (from package
\link{raster}).}

\item{ncells}{An integer giving the number of cells to compute the oriented
gradients of the HOG descriptor. Default is 24. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}

\item{orient}{An integer giving the number of orientations to compute the
oriented gradients of the HOG descriptor. Default is 8. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}
}
\value{
An object of the same classe as the input \code{slave}, with
the fixed extent. An additional attribute called \code{'affine_pars'} is
stored, containing the shift in x and y, in the same unit as the spatial
extent of the image.
}
\description{
Hyperspectral image acquisition normaly causes spatial misalignment between
the spectral bands (layers) due to both equipment (such as band-to-band
recording delay) and external factors (e.g. sensor vibrations). In this case,
a geometric correction is necessary for remote sensing applications such
as combining/merging spectral bands. This function uses the HOG (Histogram
of Oriented Gradient) descriptor in order to find the optimal translation
(xy shift) on a 'slave' band to be spatially align with a 'master'
(reference) band.
}
\details{
The affine parameters are estimated using a general
optimization algorithm. This function only estimates translation parameters.
To register bands also with rotation fixes, please check \code{\link[=registerBand3]{registerBand3()}}.
But this should be used carefully, as rotation affects the spatial dimensions.
}
\examples{
# load an image
path <- system.file('exdata', 'obory.dat', package = 'hyperbrick')
dpath <- system.file('exdata', 'obory_dark.dat', package = 'hyperbrick')
im <- buildBrick(path, hFOV = 36.8, vFOV = 36.8, height = 45,
                ref_layer = 35, spectral_feature = 'radiance',
                dark_path = dpath)
print(im)

# check bands 11 (550 nm) and 35 (670 nm)
plot(im[[35]], col = gray.colors(20), asp = 0)
plot(im[[11]], add = TRUE, legend = FALSE,
    col = adjustcolor(heat.colors(20), 0.3))

# register band 11 to band 35
new11 <- registerBand(slave = im[[11]], master = im[[35]])
plot(im[[35]], col = gray.colors(20), asp = 0)
plot(new11, add = TRUE, legend = FALSE,
    col = adjustcolor(heat.colors(20), 0.3))

# see the xy shift on band 11
attr(new11, "affine_pars")

}
\seealso{
\code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}, \code{\link[=registerBrick]{registerBrick()}}, \code{\link[=registerBand3]{registerBand3()}}
}
