% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{as_json}
\alias{as_json}
\title{Convert character string to JSON}
\usage{
as_json(x)
}
\arguments{
\item{x}{Character storing JS code or object.}
}
\value{
A character of class 'json'.
The output can be used to store bare JS element withing JSON object.
}
\description{
Allows to include raw JS code in JSON object.
}
\details{
Along with \code{json_verbatim = TRUE} argument of \link[jsonlite]{toJSON}
makes passing the code to JSON object possible.
}
\examples{
# Function stored as text
jsonlite::toJSON(
  list(fun = "function(x) {console.log(x);}"),
  auto_unbox = TRUE, json_verbatim = TRUE
)
# Function stored as raw JS object
jsonlite::toJSON(
  list(fun = as_json("function(x) {console.log(x);}")),
  auto_unbox = TRUE, json_verbatim = TRUE
)
}
