% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_update.R
\name{hs_update}
\alias{hs_update}
\title{Update annotations}
\source{
\url{https://h.readthedocs.io/en/latest/api/#update}
}
\usage{
hs_update(token, id, uri = NULL, user = NULL, permissions = NULL,
  document = NULL, target = NULL, tags = NULL, text = NULL,
  custom = NULL)
}
\arguments{
\item{token}{Character. Your account token, which you can generate at \url{https://hypothes.is/register}.}

\item{id}{Character. A hypothes.is annotation id.}

\item{uri}{Character. The URI to be annotated.}

\item{user}{Character. Your user account, normally in the format \code{acct:username@hypothes.is}}

\item{permissions}{A named list with read, update, delete, and admin permissions. Defaults to setting global read permissions (\code{group:__world__}) and setting the \code{user} string for update, delete, and admin permissions.}

\item{document}{A list describing the document. CURRENTLY IGNORED.}

\item{target}{A list describing the highlight position of the annotation. CURRENTLY IGNORED}

\item{tags}{Character. (optional) Tags to apply to the annotation.}

\item{text}{Character. Text to put in the body of the annotation. This will be coerced into a character vector of length 1 using \link{paste}.}

\item{custom}{Add arbitrary fields to the JSON object submitted to hypothes.is by means of a named list.}
}
\value{
TRUE on successful update.
}
\description{
Update annotations
}
\examples{
\dontrun{
hs_update(user_token, "lDf9rC3EEea6ck-G5kLdXA", text = "Now even more annotate-y!")
}
}

