% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{is_intercept}
\alias{is_intercept}
\alias{which_intercept}
\alias{has_intercept}
\title{Intercept checks}
\usage{
is_intercept(x)

which_intercept(x)

has_intercept(x)
}
\arguments{
\item{x}{A hypr object}
}
\value{
A single logical value (\code{has_intercept}), a logical vector (\code{is_intercept}), or an integer index vector (\code{which_intercept})
}
\description{
Non-centered contrasts require an intercept for correct specification of experimental hypotheses.
}
\details{
There are functions available to check whether a \code{hypr} object contains an intercept (\code{has_intercept}) or which contrast is the intercept (\code{is_intercept}, \code{which_intercept}).
}
\section{Functions}{
\itemize{
\item \code{which_intercept}: Return indices, not a logical vector of intercept columns

\item \code{has_intercept}: Check whether any of the contrasts is an intercept
}}

\examples{

h1 <- hypr(mu1~0, mu2~mu1)
h2 <- hypr(mu2~mu1, mu3~mu1)

stopifnot(has_intercept(h1))
stopifnot(!has_intercept(h2))
stopifnot(which_intercept(h1) == 1)
stopifnot(is_intercept(h1) == c(TRUE,FALSE))

}
