% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{add_intercept}
\alias{add_intercept}
\alias{remove_intercept}
\alias{is_intercept}
\alias{which_intercept}
\alias{has_intercept}
\title{Intercept checks}
\usage{
add_intercept(x)

remove_intercept(x)

is_intercept(x)

which_intercept(x)

has_intercept(x)
}
\arguments{
\item{x}{A hypr object}
}
\value{
A single logical value (\code{has_intercept}), a logical vector (\code{is_intercept}), an integer index vector (\code{which_intercept}), or a modified hypr object (\code{add_intercept}, \code{remove_intercept})
}
\description{
Non-centered contrasts require an intercept for correct specification of experimental hypotheses. These functions enable the user to check for existance of intercepts and to add or remove intercept columns as needed.
}
\details{
There are functions available to check whether a \code{hypr} object contains an intercept (\code{has_intercept}) or which contrast is the intercept (\code{is_intercept}, \code{which_intercept}). Moreover, if needed, the user can add (\code{add_intercept}) or remove (\code{remove_intercept}) an intercept column to/from a hypr object. \code{add_intercept} and \code{remove_intercept} do not throw an error if the user attempts to remove a non-existing intercept or add an intercept if there already is one.
}
\section{Functions}{
\itemize{
\item \code{add_intercept}: Add an intercept column if there is none

\item \code{remove_intercept}: Remove the intercept column if there is one

\item \code{which_intercept}: Return indices, not a logical vector of intercept columns

\item \code{has_intercept}: Check whether any of the contrasts is an intercept
}}

\examples{

h1 <- hypr(mu1~0, mu2~mu1)
h2 <- hypr(mu2~mu1, mu3~mu1)

stopifnot(has_intercept(h1))
stopifnot(!has_intercept(h2))
stopifnot(which_intercept(h1) == 1)
stopifnot(is_intercept(h1) == c(TRUE,FALSE))

}
