% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_okerr.R
\name{is_okerr}
\alias{is_okerr}
\alias{is_ok}
\alias{is_ok.default}
\alias{is_ok.incidence2_fit}
\alias{is_error}
\alias{is_error.default}
\alias{is_error.incidence2_fit}
\alias{is_warning}
\alias{is_warning.default}
\alias{is_warning.incidence2_fit}
\alias{is_err.incidence2_fit}
\title{Error handling for incidence2_fit objects}
\usage{
is_ok(x, ...)

\method{is_ok}{default}(x, ...)

\method{is_ok}{incidence2_fit}(x, include_warnings = FALSE, ...)

is_error(x, ...)

\method{is_error}{default}(x, ...)

\method{is_error}{incidence2_fit}(x, ...)

is_warning(x, ...)

\method{is_warning}{default}(x, ...)

\method{is_warning}{incidence2_fit}(x, ...)
}
\arguments{
\item{x}{The output of function \code{\link[=fit_curve.incidence2]{fit_curve.incidence2()}}.}

\item{...}{Not currently used.}

\item{include_warnings}{Include results in output that triggered warnings but
not errors.  Defaults to \code{FALSE}.}
}
\description{
These functions are used to filter succesful model fits from those that
errored or gave warnings.
}
\details{
The following accessors are available:
\itemize{
\item \code{is_ok()}: returns rows from an \code{\link{incidence2_fit}} object that did not
error (and optionally produce a warning).
\item \code{is_error()}: returns rows from an \code{\link{incidence2_fit}} object that errored.
\item \code{is_warning()}: returns rows from an \code{\link{incidence2_fit}} object that
produced warnings.
}
}
