% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curve.R
\name{fit_curve}
\alias{fit_curve}
\title{Fit an epi curve}
\usage{
fit_curve(x, model = c("poisson", "negbin"), alpha = 0.05, ...)
}
\arguments{
\item{x}{An \link[incidence2:incidence]{incidence2::incidence} object.}

\item{model}{\verb{[character]}

The regression model to fit (can be "poisson" or "negbin").}

\item{alpha}{\verb{[numeric]}

Value of alpha used to calculate confidence intervals; defaults to 0.05 which
corresponds to a 95\% confidence interval.}

\item{...}{Additional arguments to pass to \code{\link[stats:glm]{stats::glm()}} for \code{model = "poisson"} or
\code{\link[MASS:glm.nb]{MASS::glm.nb()}} for \code{model = "negbin"}.}
}
\value{
An object of class \code{incidence2_fit}.
}
\description{
Fit an epi curve
}
