% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sim.R
\name{check_sim}
\alias{check_sim}
\title{Check the similarity matrix passed to a matching function}
\usage{
check_sim(sim, seeds, nonseeds, totv1, totv2, for_nonseeds = TRUE)
}
\arguments{
\item{sim}{Similarity matrix}

\item{seeds}{dataframe of seed matches from running \link{check_seeds}}

\item{nonseeds}{dataframe of nonseed nodes from running \link{check_seeds}}

\item{totv1}{total number of vertices in the first graph}

\item{totv2}{total number of vertices in the second graph}

\item{for_nonseeds}{Whether the similarities are between non-seed nodes only (default = TRUE), or 
if similarities among seed nodes are included (FALSE)}
}
\value{
Standardized similarity matrix for similarities only between nonseeds across
 the two graphs, if for_nonseeds = TRUE, or between all nodes, if for_nonseeds = FALSE
}
\description{
Internal function that checks that a similarity matrix satisfies
 necessary conditions and modifies it for use in graph matching.
}
\details{
The goal here is to be flexible in terms of the dimensions of the similarity matrix
 passed to \link{gm}. This is useful when the graphs have different orders in which case
 the function accepts matrices with dimensions equal to that of orders of the original graphs
 or the number of nonseeds.
}
