/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class PowerDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double c;

    public PowerDist(double a, double b, double c) {
        this.setParams(a, b, c);
    }

    public PowerDist(double b, double c) {
        this.setParams(0.0, b, c);
    }

    public PowerDist(double c) {
        this.setParams(0.0, 1.0, c);
    }

    public double density(double x) {
        return PowerDist.density(this.a, this.b, this.c, x);
    }

    public double cdf(double x) {
        return PowerDist.cdf(this.a, this.b, this.c, x);
    }

    public double barF(double x) {
        return PowerDist.barF(this.a, this.b, this.c, x);
    }

    public double inverseF(double u) {
        return PowerDist.inverseF(this.a, this.b, this.c, u);
    }

    public double getMean() {
        return PowerDist.getMean(this.a, this.b, this.c);
    }

    public double getVariance() {
        return PowerDist.getVariance(this.a, this.b, this.c);
    }

    public double getStandardDeviation() {
        return PowerDist.getStandardDeviation(this.a, this.b, this.c);
    }

    public static double density(double a, double b, double c, double x) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        if (x >= b) {
            return 0.0;
        }
        double z = (x - a) / (b - a);
        return c * Math.pow(z, c - 1.0) / (b - a);
    }

    public static double cdf(double a, double b, double c, double x) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        if (x >= b) {
            return 1.0;
        }
        return Math.pow((x - a) / (b - a), c);
    }

    public static double barF(double a, double b, double c, double x) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 1.0;
        }
        if (x >= b) {
            return 0.0;
        }
        return 1.0 - Math.pow((x - a) / (b - a), c);
    }

    public static double inverseF(double a, double b, double c, double u) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u == 0.0) {
            return a;
        }
        if (u == 1.0) {
            return b;
        }
        return a + (b - a) * Math.pow(u, 1.0 / c);
    }

    public static double[] getMLE(double[] x, int n, double a, double b) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d = b - a;
        double somme = 0.0;
        for (int i = 0; i < n; ++i) {
            somme += Math.log((x[i] - a) / d);
        }
        double[] parametres = new double[]{-1.0 / (somme / (double)n)};
        return parametres;
    }

    public static PowerDist getInstanceFromMLE(double[] x, int n, double a, double b) {
        double[] parameters = PowerDist.getMLE(x, n, a, b);
        return new PowerDist(a, b, parameters[0]);
    }

    public static double getMean(double a, double b, double c) {
        return a + (b - a) * c / (c + 1.0);
    }

    public static double getVariance(double a, double b, double c) {
        return (b - a) * (b - a) * c / ((c + 1.0) * (c + 1.0) * (c + 2.0));
    }

    public static double getStandardDeviation(double a, double b, double c) {
        return Math.sqrt(PowerDist.getVariance(a, b, c));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.c};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + " : b = " + this.b + " : c = " + this.c;
    }
}

