/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import mrmc.chart.ROCCurvePlot;
import mrmc.chart.exportToFile;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.MRMC;
import mrmc.core.Matrix;
import mrmc.gui.InputFileCard;
import mrmc.gui.InputStartCard;
import mrmc.gui.InputSummaryCard;
import mrmc.gui.ManualCard;
import mrmc.gui.SizePanel;
import mrmc.gui.StatPanel;

public class GUInterface {
    private GUInterface thisGUI = this;
    public MRMC MRMCobject;
    public InputStartCard InputStartCard;
    public InputFileCard InputFileCard;
    public InputSummaryCard InputSummaryCard;
    private ManualCard MC;
    public File inputfileDirectory = null;
    public static File outputfileDirectory = null;
    public InputFile InputFile1 = new InputFile();
    public String allAnalysisOutput = "";
    public DBRecord DBRecordStat = new DBRecord(this);
    public DBRecord DBRecordSize = new DBRecord(this);
    private DBRecord DBRecordStatAll = new DBRecord(this);
    public int resetcall = 0;
    public static final int USE_MLE = 1;
    public static final int NO_MLE = 0;
    public static String summaryfilename = "";
    public static final String DescInputModeOmrmc = "Summary info from a reader study";
    public static final String DescInputModeImrmc = "Reader study data";
    public static final String DescInputChooseMode = "Please choose input file mode";
    public static String selectedInput = "Please choose input file mode";
    JPanel InputPane;
    JPanel manual3;
    public StatPanel StatPanel1;
    SizePanel SizePanel1;
    public static final String NO_MOD = "NO_MOD";
    private int selectedDB = 0;
    private int selectedSummary = 0;
    public boolean hasNegative = false;
    DecimalFormat twoDec = new DecimalFormat("0.00");
    DecimalFormat threeDec = new DecimalFormat("0.000");
    DecimalFormat threeDecE = new DecimalFormat("0.000E0");
    DecimalFormat fourDec = new DecimalFormat("0.0000");

    public void resetGUI() {
        this.InputFile1.resetInputFile();
        this.resetcall = 1;
        this.DBRecordStat.resetDBRecord();
        this.InputFileCard.resetInputFileCard();
        this.InputSummaryCard.resetInputSummaryCard();
        this.resetcall = 0;
        this.StatPanel1.resetStatPanel();
        this.SizePanel1.resetSizePanel();
        this.StatPanel1.enableTabs();
    }

    public JTextArea genFrame() {
        JFrame descFrame = new JFrame();
        descFrame.getRootPane().setWindowDecorationStyle(2);
        String str = "";
        JTextArea desc = new JTextArea(str, 18, 40);
        JScrollPane scrollPane = new JScrollPane(desc, 22, 32);
        descFrame.getContentPane().add(scrollPane);
        desc.setLineWrap(true);
        desc.setEditable(false);
        descFrame.pack();
        descFrame.setVisible(true);
        return desc;
    }

    public String getSelectedInput() {
        return selectedInput;
    }

    public int getSingleOrDiff() {
        return this.MC.getSingleOrDiff();
    }

    public int getSelectedManualComp() {
        return this.MC.getSelectedManualComp();
    }

    public GUInterface(MRMC MRMCobjectTemp, Container cp) {
        this.MRMCobject = MRMCobjectTemp;
        this.SizePanel1 = new SizePanel(this);
        this.StatPanel1 = new StatPanel(this.MRMCobject.getFrame(), this.DBRecordStat);
        cp.setLayout(new BoxLayout(cp, 1));
        JPanel inputSelectPane = new JPanel();
        inputSelectPane.setLayout(new FlowLayout());
        JLabel inLabel = new JLabel("Select an input method: ");
        String[] comboBoxItems = new String[]{DescInputChooseMode};
        JComboBox<String> cb = new JComboBox<String>(comboBoxItems);
        JComboBox chooseMod = new JComboBox();
        cb.addItem(DescInputModeImrmc);
        cb.addItem(DescInputModeOmrmc);
        cb.setEditable(false);
        cb.setSelectedIndex(0);
        cb.addActionListener(new inputModListener());
        JButton buttonReset = new JButton("Reset");
        buttonReset.addActionListener(new ResetListener());
        inputSelectPane.add(inLabel);
        inputSelectPane.add(cb);
        inputSelectPane.add(buttonReset);
        JPanel JPanel_InputFileCard = new JPanel();
        this.InputFileCard = new InputFileCard(JPanel_InputFileCard, this);
        JPanel JPanel_InputStartCard = new JPanel();
        this.InputStartCard = new InputStartCard(JPanel_InputStartCard, this);
        JPanel JPanel_InputSummaryCard = new JPanel();
        this.InputSummaryCard = new InputSummaryCard(JPanel_InputSummaryCard, this);
        this.InputPane = new JPanel(new CardLayout());
        this.InputPane.add((Component)JPanel_InputStartCard, DescInputChooseMode);
        this.InputPane.add((Component)JPanel_InputFileCard, DescInputModeImrmc);
        this.InputPane.add((Component)JPanel_InputSummaryCard, DescInputModeOmrmc);
        this.StatPanel1.resetStatPanel();
        this.StatPanel1.resetTable1();
        this.SizePanel1.resetSizePanel();
        JPanel panelSep = new JPanel(new BorderLayout());
        panelSep.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1));
        panelSep.add((Component)new JSeparator(0), "Center");
        JPanel panelSep2 = new JPanel(new BorderLayout());
        panelSep2.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 1));
        panelSep2.add((Component)new JSeparator(0), "Center");
        JPanel panelSep3 = new JPanel(new BorderLayout());
        panelSep3.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 1));
        panelSep3.add((Component)new JSeparator(0), "Center");
        JPanel panelSummary = new JPanel();
        JButton saveStatAnalysis = new JButton("Save Stat Analysis");
        saveStatAnalysis.addActionListener(new SaveStatAnalysisButtonListener());
        panelSummary.add(saveStatAnalysis);
        JButton saveSize = new JButton("Save Size Analysis");
        saveSize.addActionListener(new SaveGUISizeListener());
        panelSummary.add(saveSize);
        JButton saveAll = new JButton("Analyze All Modalities");
        saveAll.addActionListener(new SaveAllStatListener());
        panelSummary.add(saveAll);
        cp.add(inputSelectPane);
        cp.add(this.InputPane);
        cp.add(panelSep);
        cp.add(this.StatPanel1.JPanelStat);
        cp.add(panelSep2);
        cp.add(this.SizePanel1.JPanelSize);
        cp.add(panelSep3);
        cp.add(panelSummary);
    }

    public int calFactorial(int n) {
        int factorial = 1;
        int i = 1;
        while (i <= n) {
            factorial *= i;
            ++i;
        }
        return factorial;
    }

    class MLESelListener
    implements ActionListener {
        MLESelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double x = 1 / 0;
            String str = e.getActionCommand();
            if (str.equals("Yes")) {
                GUInterface.this.DBRecordStat.flagMLE = 1;
            }
            if (str.equals("No")) {
                GUInterface.this.DBRecordStat.flagMLE = 0;
            }
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GUInterface.this.resetGUI();
        }
    }

    public class SaveAllStatListener
    implements ActionListener {
        private String BDGout;
        private String BCKout;
        private String DBMout;
        private String ORout;
        private String MSout;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.exportResult();
        }

        public void exportResult() {
            block21: {
                if (GUInterface.this.InputFile1.isLoaded()) {
                    SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
                    Date currDate = new Date();
                    String fileTime = dateForm.format(currDate);
                    String filePathAndName = GUInterface.this.InputFile1.filePathAndName;
                    filePathAndName = filePathAndName.substring(0, filePathAndName.lastIndexOf("."));
                    filePathAndName = GUInterface.this.allAnalysisOutput.length() != 0 ? GUInterface.this.allAnalysisOutput : String.valueOf(filePathAndName) + fileTime;
                    File outputDir = new File(filePathAndName);
                    if (!outputDir.exists() && !outputDir.isDirectory()) {
                        outputDir.mkdir();
                    }
                    String AllStatPath = outputDir + "//statAnalysis.csv";
                    String AllStatMLEPath = outputDir + "//statAnalysisMLE.csv";
                    String AllAUCsPath = outputDir + "//AUCperReader.csv";
                    String AllReaderCovPath = outputDir + "//readerCovariance.csv";
                    String AllROCPath = outputDir + "//ROCcurves.csv";
                    String BDGtable = outputDir + "//BDGtable.csv";
                    String BCKtable = outputDir + "//BCKtable.csv";
                    String DBMtable = outputDir + "//DBMtable.csv";
                    String ORtable = outputDir + "//ORtable.csv";
                    String MStable = outputDir + "//MStable.csv";
                    String statHead = "inputFile,date,iMRMCversion,NR,N0,N1,modalityA,modalityB,UstatOrMLE,AUCA,varAUCA,AUCB,varAUCB,AUCAminusAUCB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis";
                    this.BDGout = "modalityA,modalityB,UstatOrMLE,compOrCoeff,M1,M2,M3,M4,M5,M6,M7,M8\r\n";
                    this.BCKout = "modalityA,modalityB,UstatOrMLE,Moments,N,D,ND,R,NR,DR,RND\r\n";
                    this.DBMout = "modalityA,modalityB,UstatOrMLE,Components,R,C,RC,TR,TC,TRC\r\n";
                    this.ORout = "modalityA,modalityB,UstatOrMLE,Components,R,TR,COV1,COV2,COV3,ERROR\r\n";
                    this.MSout = "modalityA,modalityB,UstatOrMLE,Components,R,C,RC,MR,MC,MRC\r\n";
                    String AllStatreport = String.valueOf(statHead) + "\r\n";
                    String AllStatMLEreport = String.valueOf(statHead) + "\r\n";
                    String AllAUCsreport = "inputFile,date,iMRMCversion,readerID,N0,N1,modalityA,modalityB,AUCA,varAUCA,AUCB,varAUCB,AUCAminusAUCB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis\r\n";
                    String readerCovReport = "inputFile,data,iMRMCversion\r\n" + GUInterface.this.InputFile1.fileName + "," + fileTime + ',' + "iMRMC Version 4.0.3" + "\r\n";
                    String AllROCreport = "";
                    if (selectedInput == GUInterface.DescInputModeImrmc) {
                        System.out.println("MRMC Save All Stat button clicked");
                        int numMod = GUInterface.this.InputFile1.getModalityIDs().size();
                        int modCombination = GUInterface.this.calFactorial(numMod) / GUInterface.this.calFactorial(numMod - 2) / GUInterface.this.calFactorial(2) + numMod;
                        String[][] modCombinationList = new String[modCombination][2];
                        String[] rocMod = new String[numMod];
                        int count = 0;
                        Iterator<String> iterator = GUInterface.this.InputFile1.getModalityIDs().iterator();
                        while (iterator.hasNext()) {
                            String ModalityID;
                            modCombinationList[count][0] = ModalityID = iterator.next();
                            modCombinationList[count][1] = GUInterface.NO_MOD;
                            rocMod[count] = ModalityID;
                            ++count;
                        }
                        int i = 0;
                        while (i < numMod - 1) {
                            int j = i + 1;
                            while (j < numMod) {
                                modCombinationList[count][0] = modCombinationList[i][0];
                                modCombinationList[count][1] = modCombinationList[j][0];
                                ++count;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < count) {
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 0;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityA = modCombinationList[i][0];
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityB = modCombinationList[i][1];
                            ((GUInterface)GUInterface.this).DBRecordStatAll.selectedMod = i < numMod ? 0 : 3;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFill(GUInterface.this.InputFile1, GUInterface.this.DBRecordStatAll);
                            AllStatreport = exportToFile.exportStat(AllStatreport, GUInterface.this.DBRecordStatAll, fileTime);
                            AllAUCsreport = exportToFile.exportReaders(AllAUCsreport, GUInterface.this.DBRecordStatAll, GUInterface.this.InputFile1, fileTime);
                            readerCovReport = exportToFile.exportReadersCov(readerCovReport, GUInterface.this.DBRecordStatAll, GUInterface.this.InputFile1);
                            this.savetable();
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 1;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFill(GUInterface.this.InputFile1, GUInterface.this.DBRecordStatAll);
                            AllStatMLEreport = exportToFile.exportStat(AllStatMLEreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                            ++i;
                        }
                        ROCCurvePlot roc = new ROCCurvePlot("ROC Curve: All Modality ", "FPF (1 - Specificity), legend shows symbols for each modalityID:readerID", "TPF (Sensitivity)", GUInterface.this.InputFile1.generateROCpoints(rocMod), GUInterface.this.InputFile1.filePathAndName, GUInterface.this.InputFile1.fileName);
                        roc.addData(GUInterface.this.InputFile1.generatePooledROC(rocMod), "Pooled Average");
                        AllROCreport = exportToFile.exportROC(roc.seriesCollection, AllROCreport);
                    } else {
                        DBRecord a = GUInterface.this.DBRecordStat;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.AUCs = Matrix.copy(GUInterface.this.DBRecordStat.AUCs);
                        ((GUInterface)GUInterface.this).DBRecordStatAll.AUCsReaderAvg = Matrix.copy(GUInterface.this.DBRecordStat.AUCsReaderAvg);
                        ((GUInterface)GUInterface.this).DBRecordStatAll.LoadBDG = Matrix.copy(GUInterface.this.DBRecordStat.LoadBDG);
                        ((GUInterface)GUInterface.this).DBRecordStatAll.Ndisease = GUInterface.this.DBRecordStat.Ndisease;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.NdiseaseDB = GUInterface.this.DBRecordStat.NdiseaseDB;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.Nnormal = GUInterface.this.DBRecordStat.Nnormal;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.NnormalDB = GUInterface.this.DBRecordStat.NnormalDB;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.Nreader = GUInterface.this.DBRecordStat.Nreader;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.NreaderDB = GUInterface.this.DBRecordStat.NreaderDB;
                        DBRecord track = GUInterface.this.DBRecordStatAll;
                        ((GUInterface)GUInterface.this).DBRecordStatAll.InputFile1 = GUInterface.this.InputFile1;
                        String tempModA = "";
                        String tempModB = "";
                        if (MRMC.commandStart) {
                            tempModA = GUInterface.this.DBRecordStat.modalityA;
                            tempModB = GUInterface.this.DBRecordStat.modalityB;
                        } else {
                            tempModA = GUInterface.this.InputSummaryCard.loadmodalityA;
                            tempModB = GUInterface.this.InputSummaryCard.loadmodalityB;
                        }
                        if (tempModA != null && !tempModA.equals(GUInterface.NO_MOD)) {
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityA = tempModA;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityB = GUInterface.NO_MOD;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.selectedMod = 0;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 0;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatreport = exportToFile.exportStat(AllStatreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 1;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatMLEreport = exportToFile.exportStat(AllStatMLEreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                        }
                        DBRecord track1 = GUInterface.this.DBRecordStat;
                        if (tempModB != null && !tempModB.equals(GUInterface.NO_MOD)) {
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityA = GUInterface.NO_MOD;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityB = tempModB;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.selectedMod = 1;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 0;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatreport = exportToFile.exportStat(AllStatreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 1;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatMLEreport = exportToFile.exportStat(AllStatMLEreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                        }
                        if (tempModA != null && tempModB != null && !tempModA.equals(GUInterface.NO_MOD) && !tempModB.equals(GUInterface.NO_MOD)) {
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityA = tempModA;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.modalityB = tempModB;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.selectedMod = 3;
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 0;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatreport = exportToFile.exportStat(AllStatreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                            ((GUInterface)GUInterface.this).DBRecordStatAll.flagMLE = 1;
                            GUInterface.this.DBRecordStatAll.DBRecordStatFillSummary(GUInterface.this.DBRecordStatAll);
                            AllStatMLEreport = exportToFile.exportStat(AllStatMLEreport, GUInterface.this.DBRecordStatAll, fileTime);
                            this.savetable();
                        }
                    }
                    try {
                        FileWriter fwAllStat = new FileWriter(AllStatPath);
                        FileWriter fwAllStatMLE = new FileWriter(AllStatMLEPath);
                        FileWriter fwBDGtable = new FileWriter(BDGtable);
                        FileWriter fwBCKtable = new FileWriter(BCKtable);
                        FileWriter fwDBMtable = new FileWriter(DBMtable);
                        FileWriter fwORtable = new FileWriter(ORtable);
                        FileWriter fwMStable = new FileWriter(MStable);
                        BufferedWriter bwAllStat = new BufferedWriter(fwAllStat);
                        BufferedWriter bwAllStatMLE = new BufferedWriter(fwAllStatMLE);
                        BufferedWriter bwBDGtable = new BufferedWriter(fwBDGtable);
                        BufferedWriter bwBCKtable = new BufferedWriter(fwBCKtable);
                        BufferedWriter bwDBMtable = new BufferedWriter(fwDBMtable);
                        BufferedWriter bwORtable = new BufferedWriter(fwORtable);
                        BufferedWriter bwMStable = new BufferedWriter(fwMStable);
                        bwAllStat.write(AllStatreport);
                        bwAllStat.close();
                        bwAllStatMLE.write(AllStatMLEreport);
                        bwAllStatMLE.close();
                        bwBDGtable.write(this.BDGout);
                        bwBDGtable.close();
                        bwBCKtable.write(this.BCKout);
                        bwBCKtable.close();
                        bwDBMtable.write(this.DBMout);
                        bwDBMtable.close();
                        bwORtable.write(this.ORout);
                        bwORtable.close();
                        bwMStable.write(this.MSout);
                        bwMStable.close();
                        if (selectedInput == GUInterface.DescInputModeImrmc) {
                            FileWriter fwAllAUCs = new FileWriter(AllAUCsPath);
                            FileWriter fwAllROC = new FileWriter(AllROCPath);
                            FileWriter fwAllCov = new FileWriter(AllReaderCovPath);
                            BufferedWriter bwAllAUCs = new BufferedWriter(fwAllAUCs);
                            BufferedWriter bwAllROC = new BufferedWriter(fwAllROC);
                            BufferedWriter bwAllCov = new BufferedWriter(fwAllCov);
                            bwAllAUCs.write(AllAUCsreport);
                            bwAllAUCs.close();
                            bwAllROC.write(AllROCreport);
                            bwAllROC.close();
                            bwAllCov.write(readerCovReport);
                            bwAllCov.close();
                            if (!MRMC.commandStart) {
                                JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "All modalities combinations analysis table, result, AUCs and ROC have been succeed export to \n " + outputDir, "Exported", 1);
                            } else {
                                System.out.println("All modalities combinations analysis table, result, AUCs and ROC have been succeed export to \n " + outputDir);
                                System.exit(0);
                            }
                            break block21;
                        }
                        if (!MRMC.commandStart) {
                            JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "All modalities combinations analysis table and result have been succeed export to \n " + outputDir, "Exported", 1);
                            break block21;
                        }
                        System.out.println("All modalities combinations analysis table and result have been succeed export to \n" + outputDir);
                        System.exit(0);
                    }
                    catch (HeadlessException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "Please load Reader study data input file.", "Error", 0);
                }
            }
        }

        private void savetable() {
            this.BDGout = exportToFile.exportTableBDG(this.BDGout, GUInterface.this.DBRecordStatAll);
            this.BCKout = exportToFile.exportTableBCK(this.BCKout, GUInterface.this.DBRecordStatAll);
            this.DBMout = exportToFile.exportTableDBM(this.DBMout, GUInterface.this.DBRecordStatAll);
            this.ORout = exportToFile.exportTableOR(this.ORout, GUInterface.this.DBRecordStatAll);
            this.MSout = exportToFile.exportTableMS(this.MSout, GUInterface.this.DBRecordStatAll);
        }
    }

    class SaveGUISizeListener
    implements ActionListener {
        SaveGUISizeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GUInterface.this.DBRecordSize.totalVar > 0.0) {
                GUInterface.this.DBRecordSize.InputFile1 = GUInterface.this.InputFile1;
                String head = "inputFile,date,iMRMCversion,modalityA,modalityB,NR,N0,N1,NG,EffectiveSize,SignificanceLevel,UstatOrMLE,NormalPower,BDGDf,BDGSE,BDGPower,HillisDf,HillisPower";
                String reportcsv = String.valueOf(head) + "\r\n";
                String reportomrmc = "";
                SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
                Date currDate = new Date();
                String fileTime = dateForm.format(currDate);
                String FileName = GUInterface.this.InputFile1.fileName;
                String FilePathAndName = GUInterface.this.InputFile1.filePathAndName;
                String FilePath = GUInterface.this.InputFile1.filePath;
                FilePathAndName = FilePathAndName.substring(0, FilePathAndName.lastIndexOf("."));
                FileName = FileName.substring(0, FileName.lastIndexOf("."));
                String sizeFilename = String.valueOf(FileName) + "MRMCsize" + fileTime + ".omrmc";
                try {
                    JFileChooser fc = new JFileChooser();
                    String exportFolderName = String.valueOf(FileName) + "SizeResults" + fileTime;
                    if (outputfileDirectory != null) {
                        fc.setSelectedFile(new File(outputfileDirectory + "//" + exportFolderName));
                    } else {
                        fc.setSelectedFile(new File(String.valueOf(FilePath) + "//" + exportFolderName));
                    }
                    int fcReturn = fc.showSaveDialog((Component)e.getSource());
                    File outputPackage = fc.getSelectedFile();
                    if (!outputPackage.exists() && !outputPackage.isDirectory()) {
                        outputPackage.mkdir();
                    }
                    File fomrmc = new File(outputPackage + "//" + "MRMCsize.omrmc");
                    File fcsv = new File(outputPackage + "//" + "MRMCsize.csv");
                    outputfileDirectory = fc.getCurrentDirectory();
                    if (fcReturn == 0) {
                        sizeFilename = fomrmc.getName();
                        reportomrmc = String.valueOf(reportomrmc) + "MRMC size statistics from " + "iMRMC Version 4.0.3" + "\r\n";
                        reportomrmc = String.valueOf(reportomrmc) + "Size statistics written to file named:" + "\r\n";
                        reportomrmc = String.valueOf(reportomrmc) + sizeFilename + "\r\n" + "\r\n";
                        if (selectedInput == GUInterface.DescInputChooseMode) {
                            reportomrmc = exportToFile.exportSizePanel(reportomrmc, GUInterface.this.DBRecordSize, GUInterface.this.SizePanel1);
                            reportomrmc = exportToFile.exportTable1(reportomrmc, GUInterface.this.DBRecordSize);
                            reportcsv = exportToFile.exportSizeCsv(reportcsv, GUInterface.this.DBRecordSize, GUInterface.this.SizePanel1, fileTime);
                        } else {
                            reportomrmc = exportToFile.exportSizePanel(reportomrmc, GUInterface.this.DBRecordSize, GUInterface.this.SizePanel1);
                            reportomrmc = exportToFile.exportTable1(reportomrmc, GUInterface.this.DBRecordSize);
                            reportcsv = exportToFile.exportSizeCsv(reportcsv, GUInterface.this.DBRecordSize, GUInterface.this.SizePanel1, fileTime);
                        }
                        FileWriter fwomrmc = new FileWriter(fomrmc.getAbsoluteFile());
                        BufferedWriter bwomrmc = new BufferedWriter(fwomrmc);
                        bwomrmc.write(reportomrmc);
                        bwomrmc.close();
                        FileWriter fwcsv = new FileWriter(fcsv.getAbsoluteFile());
                        BufferedWriter bwcsv = new BufferedWriter(fwcsv);
                        bwcsv.write(reportcsv);
                        bwcsv.close();
                        outputfileDirectory = fc.getCurrentDirectory();
                        String savedfilename = fc.getSelectedFile().getName();
                        JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "The size analysis results and summary has been succeed export to " + outputfileDirectory + " !\n" + "Foldername = " + outputPackage, "Exported", 1);
                    }
                }
                catch (HeadlessException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "Size study has not yet been predicted.", "Error", 0);
            }
        }
    }

    class SaveStatAnalysisButtonListener
    implements ActionListener {
        SaveStatAnalysisButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double aaa = GUInterface.this.DBRecordStat.totalVar;
            if (GUInterface.this.DBRecordStat.totalVar > 0.0) {
                GUInterface.this.DBRecordStat.InputFile1 = GUInterface.this.InputFile1;
                String head = "inputFile,date,iMRMCversion,NR,N0,N1,modalityA,modalityB,UstatOrMLE,AUCA,varAUCA,AUCB,varAUCB,AUCAminusAUCB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis";
                String reportData = String.valueOf(head) + "\r\n";
                String reportSummary = "";
                String reportResult1 = "";
                String reportResult2 = "";
                SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
                Date currDate = new Date();
                String fileTime = dateForm.format(currDate);
                String FileName = GUInterface.this.InputFile1.fileName;
                String FilePath = GUInterface.this.InputFile1.filePath;
                String FilePathName = GUInterface.this.InputFile1.filePathAndName;
                FileName = FileName.substring(0, FileName.lastIndexOf("."));
                try {
                    JFileChooser fc = new JFileChooser();
                    String exportFolderName = String.valueOf(FileName) + "StatResults" + fileTime;
                    if (outputfileDirectory != null) {
                        fc.setSelectedFile(new File(outputfileDirectory + "//" + exportFolderName));
                    } else {
                        fc.setSelectedFile(new File(String.valueOf(FilePath) + "//" + exportFolderName));
                    }
                    int fcReturn = fc.showSaveDialog((Component)e.getSource());
                    File outputPackage = fc.getSelectedFile();
                    if (!outputPackage.exists() && !outputPackage.isDirectory()) {
                        outputPackage.mkdir();
                    }
                    File fSummary = new File(outputPackage + "//" + "MRMCSummary.omrmc");
                    File fData = new File(outputPackage + "//" + "MRMCStat.csv");
                    String fPdfPathName = outputPackage + "//" + "MRMCResult.pdf";
                    File fPdf = new File(fPdfPathName);
                    outputfileDirectory = fc.getCurrentDirectory();
                    PdfPTable[] pdfAUCTable = new PdfPTable[3];
                    int i = 0;
                    while (i < 3) {
                        pdfAUCTable[i] = new PdfPTable(5);
                        pdfAUCTable[i].setTotalWidth(new float[]{300.0f, 550.0f, 550.0f, 250.0f, 350.0f});
                        ++i;
                    }
                    if (fcReturn == 0) {
                        summaryfilename = fSummary.getName();
                        reportSummary = String.valueOf(reportSummary) + "MRMC summary statistics from " + "iMRMC Version 4.0.3" + "\r\n";
                        reportSummary = String.valueOf(reportSummary) + "Summary statistics based on input file named:" + "\r\n";
                        reportResult1 = "This file,\r\n" + fPdf.getAbsolutePath() + ",\r\n";
                        reportResult1 = String.valueOf(reportResult1) + "shows the MRMC ROC analysis results for the data in:" + "\r\n";
                        reportResult1 = String.valueOf(reportResult1) + FilePathName + "\r\n";
                        reportResult1 = String.valueOf(reportResult1) + "using " + "iMRMC Version 4.0.3" + ", https://github.com/DIDSR/iMRMC/releases" + "\r\n" + "\r\n";
                        reportSummary = String.valueOf(reportSummary) + GUInterface.this.InputFile1.filePathAndName + "\r\n" + "\r\n";
                        if (selectedInput == GUInterface.DescInputChooseMode) {
                            reportSummary = exportToFile.exportSummary(reportSummary, GUInterface.this.DBRecordStat);
                            reportSummary = exportToFile.exportStatPanel(reportSummary, GUInterface.this.DBRecordStat, GUInterface.this.StatPanel1);
                            reportSummary = exportToFile.exportTable1(reportSummary, GUInterface.this.DBRecordStat);
                            reportSummary = exportToFile.exportTable2(reportSummary, GUInterface.this.DBRecordStat);
                            reportResult1 = exportToFile.pdfResult1(reportResult1, GUInterface.this.DBRecordStat);
                            pdfAUCTable = exportToFile.pdfTable(pdfAUCTable, GUInterface.this.DBRecordStat);
                            reportResult2 = exportToFile.pdfResult2(GUInterface.this.DBRecordStat);
                            reportData = exportToFile.exportStat(reportData, GUInterface.this.DBRecordStat, fileTime);
                        } else {
                            reportSummary = exportToFile.exportSummary(reportSummary, GUInterface.this.DBRecordStat);
                            reportSummary = exportToFile.exportStatPanel(reportSummary, GUInterface.this.DBRecordStat, GUInterface.this.StatPanel1);
                            reportSummary = exportToFile.exportTable1(reportSummary, GUInterface.this.DBRecordStat);
                            reportSummary = exportToFile.exportTable2(reportSummary, GUInterface.this.DBRecordStat);
                            reportResult1 = exportToFile.pdfResult1(reportResult1, GUInterface.this.DBRecordStat);
                            pdfAUCTable = exportToFile.pdfTable(pdfAUCTable, GUInterface.this.DBRecordStat);
                            reportResult2 = exportToFile.pdfResult2(GUInterface.this.DBRecordStat);
                            reportData = exportToFile.exportStat(reportData, GUInterface.this.DBRecordStat, fileTime);
                        }
                        FileWriter fwSummary = new FileWriter(fSummary.getAbsoluteFile());
                        BufferedWriter bwSummary = new BufferedWriter(fwSummary);
                        bwSummary.write(reportSummary);
                        bwSummary.close();
                        FileWriter fwData = new FileWriter(fData.getAbsoluteFile());
                        BufferedWriter bwData = new BufferedWriter(fwData);
                        bwData.write(reportData);
                        bwData.close();
                        Document document = new Document();
                        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(fPdfPathName));
                        document.open();
                        document.add(new Paragraph(reportResult1));
                        int i2 = 0;
                        while (i2 < 3) {
                            document.add(pdfAUCTable[i2]);
                            document.add(new Paragraph("\r\n"));
                            ++i2;
                        }
                        document.add(new Paragraph(reportResult2));
                        document.close();
                        outputfileDirectory = fc.getCurrentDirectory();
                        String savedfilename = fc.getSelectedFile().getName();
                        JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "The stat analysis results and summary has been succeed export to " + outputfileDirectory + " !\n" + "Foldername = " + outputPackage, "Exported", 1);
                    }
                }
                catch (HeadlessException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (DocumentException e1) {
                    e1.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(((GUInterface)GUInterface.this).thisGUI.MRMCobject.getFrame(), "Pilot study data has not yet been analyzed.", "Error", 0);
            }
        }
    }

    class SummarySelListener
    implements ActionListener {
        SummarySelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = e.getActionCommand();
            if (str.equals("Single Modality")) {
                GUInterface.this.selectedSummary = 0;
            }
            if (str.equals("Difference")) {
                GUInterface.this.selectedSummary = 1;
            }
        }
    }

    class dbActionListener
    implements ActionListener {
        dbActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JComboBox cb = (JComboBox)evt.getSource();
            GUInterface.this.selectedDB = cb.getSelectedIndex();
        }
    }

    class descButtonListener
    implements ActionListener {
        descButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFrame descFrame = new JFrame();
            descFrame.getRootPane().setWindowDecorationStyle(2);
            JTextArea desc = new JTextArea("TODO: This should have something.", 18, 40);
            JScrollPane scrollPane = new JScrollPane(desc, 22, 32);
            descFrame.getContentPane().add(scrollPane);
            desc.setLineWrap(true);
            desc.setEditable(false);
            descFrame.pack();
            descFrame.setVisible(true);
        }
    }

    class inputModListener
    implements ActionListener {
        inputModListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JComboBox cb = (JComboBox)evt.getSource();
            selectedInput = (String)cb.getSelectedItem();
            CardLayout cl = (CardLayout)GUInterface.this.InputPane.getLayout();
            cl.show(GUInterface.this.InputPane, selectedInput);
            GUInterface.this.resetGUI();
        }
    }
}

