% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.lnl.R
\name{delta.lnl}
\alias{delta.lnl}
\title{Estimates in Linear M-model and Linear Y-model with Delta Method}
\usage{
delta.lnl(fit.M, fit.Y, rho = 0)
}
\arguments{
\item{fit.M}{a fitted model object for mediator. It must be an object
generated by function ``\code{lm}''}

\item{fit.Y}{a fitted model object for outcome. It must be an object
generated by function ``\code{lm}''. It can contain treatment-mediator
interaction}

\item{rho}{a numerical variable specifying the correlation coefficient
between the residual of the M-model and the residual of the Y-model. Its
range is between \code{-1} and \code{1}}
}
\value{
A list containing the following components: \item{M.model}{a data
frame containing the results for the M-model } \item{Y.model}{a data frame
containing the results for the Y-model }
}
\description{
Parameter estimates in system of correlated linear M-model and linear
Y-model with treatment-mediator interaction using delta method.
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
P-values are computed from normal distribution.
}
\examples{

data("jobs", package = "mediation")

fit.M <- lm(job_seek ~ treat + econ_hard + sex + age, data=jobs)
fit.Y <- lm(depress2 ~ treat + job_seek + econ_hard + sex + age, data=jobs)
delta.lnl(fit.M, fit.Y, rho=0.2)


fit.M <- lm(job_seek ~ treat + econ_hard + sex + age , data=jobs)
fit.Y <- lm(depress2 ~ treat*job_seek+ econ_hard + sex + age , data=jobs)
delta.lnl(fit.M, fit.Y, rho=0.5)

}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{estimates}
