% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure.relative.power.R
\name{figure.relative.power}
\alias{figure.relative.power}
\title{Contour Plot of Relative Power: Mediated Effect versus Total Effect,
Mediated Effect versus Direct Effect}
\usage{
figure.relative.power(comparison = "mediated2main", n = 100,
  sig.level = 0.05, grid.size = 0.01)
}
\arguments{
\item{comparison}{a character string specifying the relative power to be
plotted. One of \code{"mediated2main"} (default) and
\code{"mediated2direct"}. \code{"mediated2main"} requests the log of power
ratio for the mediated effect versus the main effect assuming there is no
direct effect (\eqn{c'=0}). \code{"mediated2direct"} requests the log of
power ratio for the mediated effect versus the direct effect assuming
\eqn{ab=c'}}

\item{n}{sample size}

\item{sig.level}{significance level used for the test of the mediated effect}

\item{grid.size}{grid size for \eqn{a^2} and \eqn{b^2}}
}
\value{
A plot generated using package \code{plotly}
}
\description{
Contour plot of relative power of mediated effect versus total effect in the
absence of direct effect and relative power of mediated effect versus direct
effect when \eqn{ab=c'}.
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
Basic three-factor mediation model is assumed. Coefficients are standardized such
that the variances of treatment, mediator, and outcome are equal to 1. Note
that the y-axis is \eqn{a^2} and the x-axis is \eqn{b^2}. The default axes
labels from R function \code{plot_ly} are switched in order to make them
correct.
}
\examples{

figure.relative.power()                                # Figure 2 of Wang (2017)
figure.relative.power(comparison="mediated2direct")    # Figure 3 of Wang (2017)

}
\references{
Wang, K. (2017) Understanding power anomalies in mediation
analysis. Revision submitted.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{figure}
