% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.r
\name{iNEXTbeta3D}
\alias{iNEXTbeta3D}
\title{iNterpolation and EXTrapolation with beta diversity for TD, PD and FD}
\usage{
iNEXTbeta3D(
  data,
  diversity = "TD",
  q = c(0, 1, 2),
  datatype = "abundance",
  base = "coverage",
  level = NULL,
  nboot = 10,
  conf = 0.95,
  PDtree = NULL,
  PDreftime = NULL,
  PDtype = "meanPD",
  FDdistM = NULL,
  FDtype = "AUC",
  FDtau = NULL,
  FDcut_number = 30
)
}
\arguments{
\item{data}{(a) For \code{datatype = "abundance"}, species abundance data for a single dataset can be input as a \code{matrix/data.frame} (species-by-assemblage); data for multiple datasets can be input as a \code{list} of \code{matrices/data.frames}, with each matrix representing a species-by-assemblage abundance matrix for one of the datasets.\cr
(b) For \code{datatype = "incidence_raw"}, data for a single dataset with N assemblages can be input as a \code{list} of \code{matrices/data.frames}, with each matrix representing a species-by-sampling-unit incidence matrix for one of the assemblages; data for multiple datasets can be input as multiple lists.}

\item{diversity}{selection of diversity type: \code{'TD'} = Taxonomic diversity, \code{'PD'} = Phylogenetic diversity, and \code{'FD'} = Functional diversity.}

\item{q}{a numerical vector specifying the diversity orders. Default is \code{c(0, 1, 2)}.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or species by sampling-units incidence/occurrence matrix (\code{datatype = "incidence_raw"}) with all entries being 0 (non-detection) or 1 (detection).}

\item{base}{standardization base: coverage-based rarefaction and extrapolation for gamma, alpha, beta diversity, and four classes of dissimilarity indices (\code{base = "coverage"}), or sized-based rarefaction and extrapolation for gamma and alpha diversity (\code{base = "size"}). Default is \code{base = "coverage"}.}

\item{level}{a numerical vector specifying the particular values of sample coverage (between 0 and 1 when 
\code{base = "coverage"}) or sample sizes (\code{base = "size"}) that will be used to compute standardized
 diversity/dissimilarity. Asymptotic diversity estimator can be obtained by setting \code{level = 1}
  ( i.e., complete coverage for \code{base = "coverage"}). \cr
  By default (with \code{base = "coverage"}), 
  this function computes the standardized 3D gamma, alpha, beta diversity, and four dissimilarity indices 
  for coverage up to one (for \code{q = 1, 2}) or up to the coverage of double the reference sample size 
  (for \code{q = 0}), in increments of 0.025. The extrapolation limit for beta diversity is defined as that
   for alpha diversity. \cr
   If users set \code{base = "size"}, this function computes the size-based standardized
    3D gamma and alpha diversity estimates based on 40 equally-spaced sample sizes/knots from sample size 1 
    up to double the reference sample size.}

\item{nboot}{a positive integer specifying the number of bootstrap replications when assessing sampling uncertainty and constructing confidence intervals. Bootstrap replications are generally time consuming. Set \code{nboot = 0} to skip the bootstrap procedures. Default is \code{nboot = 10}. If more accurate results are required, set \code{nboot = 100} (or \code{nboot = 200}).}

\item{conf}{a positive number < 1 specifying the level of confidence interval. Default is 0.95.}

\item{PDtree}{(required argument for \code{diversity = "PD"}), a phylogenetic tree in Newick format for all observed species in the pooled assemblage.}

\item{PDreftime}{(argument only for \code{diversity = "PD"}), a numerical value specifying reference time for PD. Default is \code{PDreftime = NULL} (i.e., the age of the root of \code{PDtree}).}

\item{PDtype}{(argument only for \code{diversity = "PD"}), select PD type: \code{PDtype = "PD"} (effective total branch length) or \code{PDtype = "meanPD"} (effective number of equally divergent lineages). Default is \code{PDtype = "meanPD"}, where \code{meanPD = PD/tree depth}.}

\item{FDdistM}{(required argument for \code{diversity = "FD"}), a species pairwise distance matrix for all species in the pooled dataset.}

\item{FDtype}{(argument only for \code{diversity = "FD"}), select FD type: \code{FDtype = "tau_value"} for FD under a specified threshold value, or \code{FDtype = "AUC"} (area under the curve of tau-profile) for an overall FD which integrates all threshold values between zero and one. Default is \code{FDtype = "AUC"}.}

\item{FDtau}{(argument only for \code{diversity = "FD"} and \code{FDtype = "tau_value"}), a numerical value between 0 and
1 specifying the tau value (threshold level) that will be used to compute FD. If \code{FDtype = NULL} (default), 
then threshold level is set to be the mean distance between any two individuals randomly selected from the pooled 
dataset (i.e., quadratic entropy).}

\item{FDcut_number}{(argument only for \code{diversity = "FD"} and \code{FDtype = "AUC"}), a numeric number to cut [0, 1] interval into equal-spaced sub-intervals to obtain the AUC value by integrating the tau-profile. Equivalently, the number of tau values that will be considered to compute the integrated AUC value. Default is \code{FDcut_number = 30}. A larger value can be set to obtain more accurate AUC value.}
}
\value{
For \code{base = "coverage"}, return a list of seven data frames with three diversity (gamma, alpha, and beta
 diversity) and four dissimilarity measures. For \code{base = "size"}, return a list of two matrices with two diversity
 (gamma and alpha diversity).\cr 
 
 For \code{base = "coverage"}, the output in each data frame includes: 
 \item{Dataset}{the name of dataset.}
 \item{Order.q}{the diversity order of q.} 
 \item{SC}{the target standardized coverage value.}
 \item{Size/mT}{the corresponding sample size.}
 \item{Alpha/Beta/Gamma/Dissimilarity}{the estimated diversity/dissimilarity estimate.}
 \item{Method}{Rarefaction, Observed, or Extrapolation, depending on whether the target coverage is less than, equal to, or greater than the coverage of the reference sample.} 
 \item{s.e.}{standard error of standardized estimate.}
 \item{LCL, UCL}{the bootstrap lower and upper confidence limits for the diversity/dissimilarity with a default significance level of 0.95.}
 \item{Diversity}{\code{'TD'} = 'Taxonomic diversity', \code{'PD'} = 'Phylogenetic diversity', \code{'meanPD'} = 'Mean phylogenetic diversity', \code{'FD_tau'} = 'Functional diversity (given tau)', \code{'FD_AUC'} = 'Functional diversity (AUC)'}
 \item{Reftime}{the reference time for PD.}
 \item{Tau}{the threshold of functional distinctiveness between any two species for FD (under \code{FDtype = "tau_value"}).}
 Similar output is obtained for \code{base = "size"}.\cr
}
\description{
\code{iNEXTbeta3D} computes standardized 3D estimates with a common sample size
(for alpha and gamma diversity) or sample coverage (for alpha, beta, gamma diversity as well as
dissimilarity indices) for default sizes or coverage values. This function also computes standardized 3D estimates
with a particular vector of user-specified sample sizes or coverage values. See Chao et al. (2023) for the theory.
}
\examples{
\donttest{
## (R/E Analysis) Taxonomic diversity for abundance data
# Coverage-based standardized TD estimates and related statistics
data(Brazil_rainforests)
output_TDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                              datatype = 'abundance', base = "coverage", nboot = 10)
output_TDc_abun
}

# Coverage-based standardized TD estimates and related statistics by 
# user-specified coverage values
data(Brazil_rainforests)
output_TDc_abun_byuser = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                                     datatype = 'abundance', base = "coverage", nboot = 10,
                                     level = c(0.85, 0.9))
output_TDc_abun_byuser


# Size-based standardized TD estimates and related statistics
data(Brazil_rainforests)
output_TDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                              datatype = 'abundance', base = "size", nboot = 10)
output_TDs_abun


# Size-based standardized TD estimates and related statistics by user-specified sample sizes
data(Brazil_rainforests)
output_TDs_abun_byuser = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                                     datatype = 'abundance', base = "size", nboot = 10,
                                     level = c(300, 500))
output_TDs_abun_byuser

\donttest{
## (R/E Analysis) Taxonomic diversity for incidence data
# Coverage-based standardized TD estimates and related statistics
data(Second_growth_forests)
output_TDc_inci = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                              datatype = 'incidence_raw', base = "coverage", nboot = 10)
output_TDc_inci
}

# Coverage-based standardized TD estimates and related statistics by 
# user-specified coverage values
data(Second_growth_forests)
output_TDc_inci_byuser = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                                     datatype = 'incidence_raw', base = "coverage", 
                                     nboot = 10, level = c(0.9, 0.95))
output_TDc_inci_byuser


# Size-based standardized TD estimates and related statistics
data(Second_growth_forests)
output_TDs_inci = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                              datatype = 'incidence_raw', base = "size", nboot = 10)
output_TDs_inci


# Size-based standardized TD estimates and related statistics by user-specified sample sizes
data(Second_growth_forests)
output_TDs_inci_byuser = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                                     datatype = 'incidence_raw', base = "size", 
                                     nboot = 10, level = c(100, 200))
output_TDs_inci_byuser

\donttest{
## (R/E Analysis) Phylogenetic diversity for abundance data
# Coverage-based standardized PD estimates and related statistics
data(Brazil_rainforests)
data(Brazil_tree)
output_PDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'PD', 
                              datatype = 'abundance', base = "coverage", nboot = 10, 
                              PDtree = Brazil_tree, PDreftime = NULL, PDtype = 'meanPD')
output_PDc_abun


# Size-based standardized PD estimates and related statistics
data(Brazil_rainforests)
data(Brazil_tree)
output_PDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'PD', 
                              datatype = 'abundance', base = "size", nboot = 10, 
                              PDtree = Brazil_tree, PDreftime = NULL, PDtype = 'meanPD')
output_PDs_abun


## (R/E Analysis) Functional diversity for abundance data when all thresholds from 0 to 1 
## are considered
# Coverage-based standardized FD estimates and related statistics
data(Brazil_rainforests)
data(Brazil_distM)
output_FDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'FD', 
                              datatype = 'abundance', base = "coverage", nboot = 10, 
                              FDdistM = Brazil_distM, FDtype = 'AUC', FDcut_number = 30)
output_FDc_abun


# Size-based standardized FD estimates and related statistics
data(Brazil_rainforests)
data(Brazil_distM)
output_FDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'FD', 
                              datatype = 'abundance', base = "size", nboot = 10, 
                              FDdistM = Brazil_distM, FDtype = 'AUC', FDcut_number = 30)
output_FDs_abun
}


}
\references{
Chao, A., Thorn, S., Chiu, C.-H., Moyes, F., Hu, K.-H., Chazdon, R. L., Wu, J., Magnago, 
L. F. S., Dornelas, M., Zeleny, D., Colwell, R. K., and Magurran, A. E. (2023). 
Rarefaction and extrapolation with beta diversity under a framework of Hill numbers: 
the iNEXT.beta3D standardization. Ecological Monographs e1588.
}
