% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_data.R
\name{sortVars}
\alias{sortVars}
\title{Sort data by variables}
\usage{
sortVars(.data, vars, asc = rep(TRUE, length(vars)))
}
\arguments{
\item{.data}{a dataframe to sort}

\item{vars}{a character vector of variable names to sort by}

\item{asc}{logical, same length as \code{vars}.
If \code{TRUE} (default), sorted in ascending order,
otherwise descending.}
}
\value{
data.frame with tidyverse code attached
}
\description{
Sorts a dataframe by one or more variables, and returns the result
along with tidyverse code used to generate it.
}
\examples{
sorted <- sortVars(iris, vars = c("Sepal.Width", "Sepal.Length"),
    asc = c(TRUE, FALSE))
cat(code(sorted))
head(sorted)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
