% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultilinearICA.R
\name{MultilinearICA}
\alias{MultilinearICA}
\title{Multilinear independent component analysis}
\usage{
MultilinearICA(
  X,
  Js = c(3, 3, 3),
  modes = 1:3,
  algorithm = c("FastICA", "InfoMax", "ExtInfoMax", "JADE", "AuxICA1", "AuxICA2", "IPCA",
    "SIMBEC", "AMUSE", "SOBI", "FOBI", "ProDenICA", "RICA")
)
}
\arguments{
\item{X}{An rTensor object}

\item{Js}{A vector to specify the rank in each mode (Default: c(3,3,3))}

\item{modes}{A vector to specify which modes are decomposed (Default: 1:3)}

\item{algorithm}{The algorithm to decompose the input tensor in each mode (Default: "FastICA")}
}
\value{
A list containing the result of the decomposition
}
\description{
#' The input object is assumed to be a Tensor object defined by rTensor package.
In MultilinearICA, ICA function is performed in each mode of the tensor.
}
\examples{
library("rTensor")
arrX <- array(runif(10*20*30), dim=c(10,20,30))
X <- as.tensor(arrX)
Js <- c(2,3,4)
out <- MultilinearICA(X, Js=Js)
}
