% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rescale}
\alias{rescale}
\title{Rescale Mean And/Or Standard Deviation of a Vector}
\usage{
rescale(x, mu = mean(x), sigma = sd(x))
}
\arguments{
\item{x}{numeric vector}

\item{mu}{numeric value giving the desired mean}

\item{sigma}{numeric value giving the desired standard
deviation}
}
\value{
a numeric vector with the same length as \code{x} with mean \code{mu} and
standard deviation \code{sigma}.
}
\description{
Rescale Mean And/Or Standard Deviation of a Vector
}
\details{
By default, mean and standard deviation are not changed, i.e.,
\code{rescale(x)} is identical to \code{x}. Only if a value is specified
for \code{mu} and/or \code{sigma} the mean and/or the standard deviation are
rescaled.
}
\examples{
x <- runif(1000, 5, 8)

# calling rescale without specifying mu and sigma doesn't change anything
all.equal(x, rescale(x))

# change the mean without changing the standard deviation
x1 <- rescale(x, mu = 3)
all.equal(mean(x1), 3)
all.equal(sd(x1), sd(x))

# rescale mean and standard deviation
x2 <- rescale(x, mu = 3, sigma = 2)
all.equal(mean(x2), 3)
all.equal(sd(x2), 2)

}
