% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapdocs.R
\docType{data}
\name{icd9_map_pccc}
\alias{icd9_map_pccc}
\alias{icd9_map_pccc_dx}
\alias{icd9_map_pccc_pcs}
\alias{icd10_map_pccc_dx}
\alias{icd10_map_pccc_pcs}
\title{Pediatric Complex Chronic Conditions}
\description{
There are seven comorbidity maps which represent the combinations of
ICD-9, ICD-10, diagnosis and procedure codes, and three also with a
set of 'fixed' codes. (See reference).
}
\references{
Feudtner C, Feinstein JA, Zhong W, Hall M, Dai D.
  Pediatric complex chronic conditions classification system version
  2: updated for ICD-10 and complex medical technology dependence and
  transplantation. BMC Pediatr. 2014 Aug8;14:199. doi:
  10.1186/1471-2431-14-199.
  \url{https://www.ncbi.nlm.nih.gov/pubmed/25102958}
}
\seealso{
\url{https://feudtnerlab.research.chop.edu/ccc_version_2.php}

Other comorbidity maps: 
\code{\link{icd10_map_ahrq_pcs}},
\code{\link{icd9_map_ahrq}},
\code{\link{icd9_map_elix}},
\code{\link{icd9_map_hcc}},
\code{\link{icd9_map_quan_deyo}},
\code{\link{icd9_map_quan_elix}},
\code{\link{icd9_map_single_ccs}}

Other comorbidities: 
\code{\link{comorbid_hcc}()},
\code{\link{comorbid}()},
\code{\link{icd10_map_ahrq_pcs}},
\code{\link{icd9_map_ahrq}},
\code{\link{icd9_map_elix}},
\code{\link{icd9_map_hcc}},
\code{\link{icd9_map_quan_deyo}},
\code{\link{icd9_map_quan_elix}},
\code{\link{icd9_map_single_ccs}}
}
\concept{comorbidities}
\concept{comorbidity maps}
\keyword{datasets}
