% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ShortToDecimal}
\alias{icd9ShortToDecimal}
\title{icd9ShortToDecimal}
\usage{
icd9ShortToDecimal(icd9Short, leadingZeroes = FALSE,
  keepLoneDecimal = FALSE, invalidAction = c("ignore", "silent", "warn",
  "stop"))
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{leadingZeroes}{logical whether to fill out major part with zeroes, or
just truncate to the left. If E code, there is no valid code since
E800-E999 is defined. V codes could be V0x or Vxx, and so could be zero
padded.}

\item{keepLoneDecimal}{logical. Since the presence or absence of a trailing
zero in an ICD-9 code can make a difference, when converting to decimal, we
have a situation where we do not want to add trailing zeroes, but may wish
to preserve the decimal point. If this is desired, then set this value to
TRUE.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\description{
converts ICD-9 'short' form to decimal form
}
\keyword{manip}

