% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.bootstrap.R
\name{taf.bootstrap}
\alias{taf.bootstrap}
\title{Bootstrap TAF Analysis}
\usage{
taf.bootstrap(software = TRUE, data = TRUE, clean = TRUE,
  quiet = FALSE, force = FALSE)
}
\arguments{
\item{software}{whether to process \verb{SOFTWARE.bib}.}

\item{data}{whether to process \verb{DATA.bib}.}

\item{clean}{whether to \code{\link{clean}} directories during the bootstrap
procedure.}

\item{quiet}{whether to suppress messages reporting progress.}

\item{force}{whether to remove existing \verb{bootstrap/data},
\verb{bootstrap/library}, and \verb{bootstrap/software} directories
before the bootstrap procedure.}
}
\value{
Logical vector indicating which metadata files were processed.
}
\description{
Process metadata files \file{SOFTWARE.bib} and \file{DATA.bib} to set up
software and data files required for the analysis.
}
\details{
If \code{clean = TRUE} then:
\enumerate{
\item \code{clean.software()} and \code{clean.library()} are run if
      \file{SOFTWARE.bib} is processed.
\item \file{bootstrap/data} is removed if \file{DATA.bib} is processed.
}
}
\note{
This function should be called from the top directory of a TAF analysis. It
looks for a directory called \file{bootstrap} and prepares data files and
software according to metadata specifications.

The bootstrap procedure consists of the following steps:
\enumerate{
\item If a \verb{bootstrap/SOFTWARE.bib} metadata file exists, it is
      processed.
\item If a \verb{bootstrap/DATA.bib} metadata file exists, it is processed.
}

After the bootstrap procedure, software and data have been documented and
are ready to be used in the subsequent analysis. Specifically, the procedure
populates up to three new directories:
\itemize{
\item \verb{bootstrap/data} with data files.
\item \verb{bootstrap/library} with R packages compiled for the local
      platform.
\item \verb{bootstrap/software} with software files, such as R packages in
      \verb{tar.gz} source code format.
}

Model settings and configuration files can be set up within \verb{DATA.bib},
see \href{https://github.com/ices-taf/doc/wiki/Bib-entries}{TAF Wiki}.
}
\examples{
\dontrun{
taf.bootstrap()
}

}
\seealso{
\code{\link{draft.data}} and \code{\link{draft.software}} can be used to
create initial draft versions of \file{DATA.bib} and \file{SOFTWARE.bib}
metadata files.

\code{\link{taf.library}} loads a package from \verb{bootstrap/library}.

\code{\link{icesTAF-package}} gives an overview of the package.
}
