% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp2d.r
\docType{methods}
\name{SpLines}
\alias{SpLines}
\alias{SpLines,trigrid-method}
\alias{SpLines-trigrid-method}
\title{SpatialLines class object from an icosahedral grid}
\usage{
SpLines(gridObj, ...)

\S4method{SpLines}{trigrid}(gridObj, dateLine = "break", res = 15)
}
\arguments{
\item{gridObj}{Either a \code{trigrid} or a \code{hexagrid} class object.}

\item{...}{specific details of the new SpatialLines object.}

\item{dateLine}{Specifies that NAs should be introduced at the dateline to break the boundaries of the faces. 
Can be switched off by setting it to \code{FALSE}.}

\item{res}{Integer value, specifies the number of points (resolution) to be inserted between two vertices.}
}
\value{
an object of class SpatialLines.
}
\description{
SpatialLines class object from an icosahedral grid

The function will create an approporiate 2d render of the grid in the SpatialLines object format defined in the package 'sp'.
}

