% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_support.R
\name{Decode}
\alias{Decode}
\title{Coded design to readable design.}
\usage{
Decode(
  des,
  n.alts,
  lvl.names,
  coding,
  alt.cte = NULL,
  c.lvls = NULL,
  no.choice = NULL
)
}
\arguments{
\item{des}{A numeric matrix which represents the design matrix. Each row is a
profile.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{lvl.names}{A list containing character vectors with the values of each
level of each attribute.}

\item{coding}{A character vector denoting the type of coding used for each
attribute. See also \code{\link[idefix]{Profiles}}.}

\item{alt.cte}{A binary vector indicating for each alternative if an
alternative specific constant is present. The default is \code{NULL}.}

\item{c.lvls}{A list containing numeric vectors with the attribute levels for
each continuous attribute. The default is \code{NULL}.}

\item{no.choice}{An integer indicating the no choice alternative. The default
is \code{NULL}.}
}
\value{
\item{design}{A character matrix which represents the design.}
\item{lvl.balance}{A list containing the frequency of appearance of each
attribute level in the design.}
}
\description{
Transforms a coded design matrix into a design containing character attribute
levels, ready to be used in a survey. The frequency of each attribute level
in the design is also included in the output.
}
\details{
\code{des} A design matrix, this can also be a single choice set. See for
example the output of \link[idefix]{Modfed} or \link[idefix]{CEA}.

In \code{lvl.names}, the number of character vectors in the list should equal
the number of attributes in de choice set. The number of elements in each
character vector should equal the number of levels for that attribute.

Valid arguments for \code{coding} are \code{C}, \code{D} and \code{E}. When
using \code{C} the attribute will be treated as continuous and no coding will
be applied. All possible levels of that attribute should then be specified in
\code{c.lvls}. If \code{D} (dummy coding) is used
\code{\link{contr.treatment}} will be applied to that attribute. The first
attribute wil be used as reference level.  For \code{E} (effect coding)
\code{\link{contr.sum}} is applied, in this case the last attribute level is
used as reference level.

If \code{des} contains columns for alternative specific constants,
\code{alt.cte} should be specified. In this case, the first column(s) (equal
to the number of nonzero elements in \code{alt.cte}) will be removed from
\code{des} before decoding the alternatives.
}
\examples{
\dontrun{
# Example without continuous attributes.
design <- example_design 
coded <- c("D", "D", "D") # Coding.
# Levels as they should appear in survey. 
al <- list(
  c("$50", "$75", "$100"), # Levels attribute 1.
  c("2 min", "15 min", "30 min"), # Levels attribute 2.
  c("bad", "moderate", "good") # Levels attribute 3.
) 
# Decode
Decode(des = design, n.alts = 2, lvl.names = al, coding = coded) 

# Example with alternative specific constants
design <- example_design2 
coded <- c("D", "D", "D") # Coding.
# Levels as they should appear in survey. 
al <- list(
  c("$50", "$75", "$100"), # Levels attribute 1.
  c("2 min", "15 min", "30 min"), # Levels attribute 2.
  c("bad", "moderate", "good") # Levels attribute 3.
) 
# Decode
Decode(des = design, n.alts = 3, lvl.names = al, coding = coded, alt.cte = c(1, 1, 0)) 
}
}
