% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_df_to_vector.R
\name{model_df_to_vector}
\alias{model_df_to_vector}
\title{Extracts a Single Column, Summarises if from Simulation}
\usage{
model_df_to_vector(df, com_var, id_var = NULL, sum_fn = NULL)
}
\arguments{
\item{df}{A data frame of dynamic system output.}

\item{com_var}{The vector to be compared; use unquoted name (NSE).}

\item{id_var}{A character string indicating the id variable to summarise over
if required.}

\item{sum_fn}{The summary function to be used, defaults to median.}
}
\value{
Returns a numeric vector, summarised if required.
}
\description{
Extracts a Single Column, Summarises if from Simulation
}
\examples{
library(dplyr)
## Extract a vector with no repeats
model_df_to_vector(iris, Petal.Length)

## Extract a vector and summarise
df <- bind_rows(iris \%>\% mutate(sim = 1, id = 1:length(sim)),
 iris \%>\% mutate(sim = 2 , id = 1:length(sim)))

model_df_to_vector(df, Petal.Length, "id", sum_fn = mean)
}
