% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-docs.R, R/brainvis.R
\name{read_brainvis}
\alias{read_brainvis}
\title{Read 'BrainVision' data}
\usage{
read_brainvis(
  file,
  extract_path = getOption("ieegio.extract_path", NULL),
  header_only = FALSE,
  cache_ok = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file path to the data file}

\item{extract_path}{location to where the extracted information is to be
stored}

\item{header_only}{whether to only load header data}

\item{cache_ok}{whether existing cache should be reused; default is
\code{TRUE}. This input can speed up reading large data files; set to
\code{FALSE} to delete cache before importing.}

\item{verbose}{whether to print processing messages; default is \code{TRUE}}
}
\value{
A cached object that is readily to be loaded to memory; see
\code{\link{SignalDataCache}} for class definition.
}
\description{
Read 'BrainVision' data
}
\examples{

if( ieegio_sample_data("brainvis.dat", test = TRUE) ) {
  # ensure the header and marker files are downloaded as well
  ieegio_sample_data("brainvis.vhdr")
  ieegio_sample_data("brainvis.dat")
  file <- ieegio_sample_data("brainvis.vmrk")

  x <- read_brainvis(file)
  print(x)

  x$get_header()

  x$get_channel_table()

  x$get_annotations()

  channel <- x$get_channel(10)

  plot(
    channel$time,
    channel$value,
    type = "l",
    main = channel$info$Label,
    xlab = "Time",
    ylab = channel$info$Unit
  )
}

}
