% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics-streamlines.R
\name{imaging-streamlines}
\alias{imaging-streamlines}
\alias{read_streamlines}
\alias{write_streamlines}
\alias{as_ieegio_streamlines}
\alias{as_ieegio_streamlines.default}
\title{Read and write streamlines}
\usage{
read_streamlines(file, ...)

write_streamlines(
  x,
  con,
  format = c("auto", "tck", "trk", "vtk", "vtp", "vtpb"),
  ...
)

as_ieegio_streamlines(x, ...)

\method{as_ieegio_streamlines}{default}(x, vox2ras = NULL, ..., class = NULL)
}
\arguments{
\item{file, con}{path to the streamline data}

\item{...}{passed to low-level functions accordingly}

\item{x}{R object that can be converted into an \code{ieegio} streamlines
instance}

\item{format}{format to write to file, the file extensions must match
with the format}

\item{vox2ras}{volume index to 'RAS' coordinate transform matrix;
default is identity matrix and used by \code{'TRK'} format}

\item{class}{additional class to be added to the instance}
}
\value{
\code{read_streamlines} and \code{as_ieegio_streamlines} returns
a streamlines instance.
}
\description{
High-level functions to read and write streamlines, supporting \code{'TCK'},
\code{'TRK'}, \code{'TT'} (read-only), \code{'VTK'} poly-data (including
legacy \code{'.vtk'}, 'XML'-based \code{'.vtp'}, 'HDF5'-based \code{'.vtpb'})
}
\examples{


# toy example
curve <- function(t) {
  x <- sin(4 * t + sample(300, 1) / 100) + t + sample(seq_along(t)) / length(t) / 10
  y <- cos(sin(t) + 5 * t) + sample(seq_along(t)) / length(t) / 10
  z <- t * 3
  cbind(x, y, z)
}

# 10 lines, each line is represented by nx3 matrix
tracts <- lapply(seq(100, 109), function(n) {
  curve(seq_len(n) / 100)
})

# convert to streamline
x <- as_ieegio_streamlines(tracts)

# Display
print(x)
plot(x, col = 1:10)

if(system.file(package = "r3js") != '') {
  plot(x, method = "r3js")
}

# Subset the first line (transformed)
coords <- x[[1]]$coords
head(coords)

# Save different formats
tdir <- tempfile()
dir.create(tdir, showWarnings = FALSE, recursive = TRUE)

write_streamlines(x, file.path(tdir, "sample.tck"))
write_streamlines(x, file.path(tdir, "sample.trk"))
write_streamlines(x, file.path(tdir, "sample.trk.gz"))

\dontrun{

  # Require Python
  write_streamlines(x, file.path(tdir, "sample.vtk"))
  write_streamlines(x, file.path(tdir, "sample.vtp"))
  write_streamlines(x, file.path(tdir, "sample.vtpb"))

}


# Read formats
y <- read_streamlines(file.path(tdir, "sample.trk"))

# Compare x and y
diffs <- mapply(
  x = as.vector(x),
  y = as.vector(y),
  function(x, y) {
    range(x$coords - y$coords)
  }
)
# Should be floating errors
max(abs(diffs))

unlink(tdir, recursive = TRUE)

}
