% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{size}
\alias{size}
\title{Size of R objects (GNU Octave/MATLAB compatible)}
\source{
pracma size function definition - R package pracma created and maintained by Hans Werner Borchers. See \code{\link[pracma]{size}}.
}
\usage{
size(x, k)
}
\arguments{
\item{x}{An R object (array, vector, or matrix)}

\item{k}{integer specifying a particular dimension}
}
\value{
"Return the number of rows and columns of the object x as a numeric
  vector. If given a second argument, \code{size} will return the size of the
  corresponding dimension." Source: Eaton.
}
\description{
Provides the dimensions of R objects in a manner compatible with
GNU Octave/MATLAB. This function is the same as \code{\link[pracma]{size}}, except this
\code{size} can find the size of character vectors too. Some documentation from
\code{\link[pracma]{size}}.
}
\examples{

# Example from GNU Octave ndims function reference

size(matlab::ones(4, 1, 2, 1))




}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 47-48.
}
\seealso{
\code{\link[base]{dim}}, \code{\link[pracma]{size}}
}
\author{
Hans Werner Borchers (pracma size), Irucka Embry
}
