% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make.R
\name{make_ring}
\alias{graph.ring}
\alias{make_ring}
\alias{ring}
\title{Create a ring graph}
\usage{
make_ring(n, directed = FALSE, mutual = FALSE, circular = TRUE)

ring(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{directed}{Whether the graph is directed.}

\item{mutual}{Whether directed edges are mutual. It is ignored in
undirected graphs.}

\item{circular}{Whether to create a circular ring. A non-circular
ring is essentially a \dQuote{line}: a tree where every non-leaf
vertex has one child.}

\item{...}{Passed to \code{make_ring}.}
}
\value{
An igraph graph.
}
\description{
A ring is a one-dimensional lattice and this function is a special case
of \code{\link{make_lattice}}.
}
\examples{
str(make_ring(10))
str(make_ring(10, directed = TRUE, mutual = TRUE))
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{chordal_ring}},
  \code{\link{graph.extended.chordal.ring}},
  \code{\link{make_chordal_ring}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_edgelist}},
  \code{\link{graph.edgelist}},
  \code{\link{graph_from_edgelist}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_citation_graph}},
  \code{\link{graph.full.citation}},
  \code{\link{make_full_citation_graph}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.star}},
  \code{\link{make_star}}, \code{\link{star}};
  \code{\link{graph.tree}}, \code{\link{make_tree}},
  \code{\link{tree}}
}

