% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_walktrap}
\alias{cluster_walktrap}
\alias{walktrap.community}
\title{Community structure via short random walks}
\usage{
cluster_walktrap(
  graph,
  weights = NULL,
  steps = 4,
  merges = TRUE,
  modularity = TRUE,
  membership = TRUE
)
}
\arguments{
\item{graph}{The input graph, edge directions are ignored in directed
graphs.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. Larger edge
weights increase the probability that an edge is selected by the random
walker. In other words, larger edge weights correspond to stronger connections.}

\item{steps}{The length of the random walks to perform.}

\item{merges}{Logical scalar, whether to include the merge matrix in the
result.}

\item{modularity}{Logical scalar, whether to include the vector of the
modularity scores in the result. If the \code{membership} argument is true,
then it will always be calculated.}

\item{membership}{Logical scalar, whether to calculate the membership vector
for the split corresponding to the highest modularity value.}
}
\value{
\code{cluster_walktrap()} returns a \code{\link[=communities]{communities()}}
object, please see the \code{\link[=communities]{communities()}} manual page for details.
}
\description{
This function tries to find densely connected subgraphs, also called
communities in a graph via random walks. The idea is that short random walks
tend to stay in the same community.
}
\details{
This function is the implementation of the Walktrap community finding
algorithm, see Pascal Pons, Matthieu Latapy: Computing communities in large
networks using random walks, https://arxiv.org/abs/physics/0512106
}
\examples{

g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1, 6, 1, 11, 6, 11))
cluster_walktrap(g)

}
\references{
Pascal Pons, Matthieu Latapy: Computing communities in large
networks using random walks, https://arxiv.org/abs/physics/0512106
}
\seealso{
See \code{\link[=communities]{communities()}} on getting the actual membership
vector, merge matrix, modularity score, etc.

\code{\link[=modularity]{modularity()}} and \code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}},
\code{\link[=cluster_spinglass]{cluster_spinglass()}},
\code{\link[=cluster_leading_eigen]{cluster_leading_eigen()}},
\code{\link[=cluster_edge_betweenness]{cluster_edge_betweenness()}}, \code{\link[=cluster_louvain]{cluster_louvain()}},
and \code{\link[=cluster_leiden]{cluster_leiden()}} for other community detection
methods.

Other community: 
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{compare}()},
\code{\link{contract}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\author{
Pascal Pons (\url{http://psl.pons.free.fr/}) and Gabor Csardi
\email{csardi.gabor@gmail.com} for the R and igraph interface
}
\concept{community}
\keyword{graphs}
