% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_gnp}
\alias{sample_gnp}
\alias{gnp}
\title{Generate random graphs according to the \eqn{G(n,p)} Erdős-Rényi model}
\usage{
sample_gnp(n, p, directed = FALSE, loops = FALSE)

gnp(...)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p}{The probability for drawing an edge between two
arbitrary vertices (\eqn{G(n,p)} graph).}

\item{directed}{Logical, whether the graph will be directed, defaults to
FALSE.}

\item{loops}{Logical, whether to add loop edges, defaults to FALSE.}

\item{...}{Passed to \code{sample_gnp()}.}
}
\value{
A graph object.
}
\description{
This model is very simple, every possible edge is created with the same
constant probability.
}
\details{
The graph has \sQuote{n} vertices and for each edge the
probability that it is present in the graph is \sQuote{p}.
}
\examples{

g <- sample_gnp(1000, 1 / 1000)
degree_distribution(g)
}
\references{
Erdos, P. and Renyi, A., On random graphs, \emph{Publicationes
Mathematicae} 6, 290--297 (1959).
}
\seealso{
\code{\link[=sample_gnm]{sample_gnm()}}, \code{\link[=sample_pa]{sample_pa()}}

Other games: 
\code{\link{connect}()},
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_gnm}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()}

Other games: 
\code{\link{connect}()},
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_gnm}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
