% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees.R
\name{is_forest}
\alias{is_forest}
\title{Decide whether a graph is a forest.}
\usage{
is_forest(graph, mode = c("out", "in", "all", "total"), details = FALSE)
}
\arguments{
\item{graph}{An igraph graph object}

\item{mode}{Whether to consider edge directions in a directed graph.
\sQuote{all} ignores edge directions; \sQuote{out} requires edges to be
oriented outwards from the root, \sQuote{in} requires edges to be oriented
towards the root.}

\item{details}{Whether to return only whether the graph is a tree (\code{FALSE})
or also a possible root (\code{TRUE})}
}
\value{
When \code{details} is \code{FALSE}, a logical value that indicates
whether the graph is a tree. When \code{details} is \code{TRUE}, a named
list with two entries: \item{res}{Logical value that indicates whether the
graph is a tree.} \item{root}{The root vertex of the tree; undefined if
the graph is not a tree.}
}
\description{
\code{is_forest()} decides whether a graph is a forest, and optionally returns a
set of possible root vertices for its components.
}
\details{
An undirected graph is a forest if it has no cycles. In the directed case,
a possible additional requirement is that edges in each tree are oriented
away from the root (out-trees or arborescences) or all edges are oriented
towards the root (in-trees or anti-arborescences). This test can be
controlled using the mode parameter.

By convention, the null graph (i.e. the graph with no vertices) is considered
to be a forest.
}
\examples{

g <- make_tree(3) + make_tree(5,3)
is_forest(g)
is_forest(g, details = TRUE)

}
\seealso{
Other trees: 
\code{\link{is_tree}()},
\code{\link{make_from_prufer}()},
\code{\link{sample_spanning_tree}()},
\code{\link{to_prufer}()}
}
\concept{trees}
\keyword{graphs}
