% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\docType{methods}
\name{add_row_summary}
\alias{add_row_summary}
\alias{add_row_summary,Iheatmap-method}
\title{add_row_summary}
\usage{
\S4method{add_row_summary}{Iheatmap}(p, groups = NULL, heatmap_name = NULL,
  colors = NULL, tracename = "Row Summary", showlegend = FALSE,
  side = c("right", "left"), layout = list(), size = 0.3, buffer = 0.02,
  xname = NULL, yname = current_yaxis(p), type = c("scatter", "bar"),
  summary_function = c("mean", "median", "sd", "var", "mad", "max", "min"),
  ...)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{groups}{vector of group labels, name of groups colorbar, or TRUE -- 
see Details}

\item{heatmap_name}{name of a heatmap within the \code{\link{Iheatmap-class}}
object}

\item{colors}{vector of colors or RColorBrewer palette name}

\item{tracename}{name of trace}

\item{showlegend}{show legend?}

\item{side}{side of plot on which to add subplot}

\item{layout}{xaxis layout list}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{type}{scatter or bar?}

\item{summary_function}{summary function to use, default is mean, options 
are mean, median, sd, var, mad, max, min}

\item{...}{additional arguments to \code{\link{add_row_plot}} or 
\code{\link{add_row_barplot}}}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds a line plot summarizing the values across rows
}
\details{
If adding the row summary to a horizontally oriented heatmap, the summary 
will be based on the right-most heatmap if side is "right" and based on the 
left heatmap if side is "left" unless a "heatmap_name" is specified. The 
heatmap_name should match the "pname" argument given to a previously added
heatmap.

The row summary is based on specific columns if a "groups" argument
is given. The groups argument can either be a vector of group assignments for 
each row, the "pname" for an existing set of groups incorporated into the 
plot using \code{\link{add_col_groups}}, \code{\link{add_col_annotation}}, 
\code{\link{add_col_clusters}}, or \code{\link{add_col_clustering}}.  If 
groups is set to TRUE, then the function will use an existing set of column 
groups added to the plot.
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm1 <- iheatmap(mat) \%>\% add_row_summary()
hm2 <- iheatmap(mat) \%>\% add_row_summary(groups = c("A","A","B","B","B"))

# Print heatmap if interactive session 
if (interactive()) hm1
if (interactive()) hm2
}
\seealso{
\code{\link{add_col_summary}}, \code{\link{iheatmap}}, 
\code{\link{add_row_plot}}
}
\author{
Alicia Schep
}
