% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{add_row_groups}
\alias{add_row_groups}
\alias{add_row_groups,Iheatmap-method}
\title{add_row_groups}
\usage{
\S4method{add_row_groups}{Iheatmap}(
  p,
  groups,
  name = "Row<br>Groups",
  title = "Groups",
  colors = pick_discrete_colors(groups, p),
  colorbar_position = get_colorbar_position(p),
  show_colorbar = TRUE,
  show_title = TRUE,
  side = c("right", "left"),
  layout = list(),
  size = 0.05,
  buffer = 0.005,
  tooltip = setup_tooltip_options(),
  xname = NULL,
  yname = current_yaxis(p),
  pname = name
)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{groups}{vector of group names}

\item{name}{name of colorbar}

\item{title}{name of x axis label}

\item{colors}{palette name or vector of colors}

\item{colorbar_position}{colorbar placement}

\item{show_colorbar}{show the colorbar?}

\item{show_title}{show title as axis label}

\item{side}{side of plot on which to groups annotation}

\item{layout}{list of layout parameters for x axis}

\item{size}{relative size of dendrogram (relative to the main heatmap)}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{tooltip}{tooltip options, see \code{\link{setup_tooltip_options}}}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{pname}{internal name of plot}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds annotation to heatmap indicating what group every row of main heatmap
belongs to
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)
row_groups <- c("A","A","B","D")
hm <- iheatmap(mat) \%>\% add_row_groups(row_groups, name = "My Groups")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{iheatmap}}, \code{\link{add_col_groups}}
}
\author{
Alicia Schep
}
