% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitcombine.R
\name{imager.combine}
\alias{add}
\alias{average}
\alias{enorm}
\alias{imager.combine}
\alias{mult}
\alias{parmax}
\alias{parmin}
\title{Combining images}
\usage{
add(x)

average(x)

mult(x)

parmax(x)

parmin(x)

enorm(x)
}
\arguments{
\item{x}{a list of images}
}
\description{
These functions take a list of images and combine them by adding, multiplying, taking the parallel min or max, etc.
}
\section{Functions}{
\itemize{
\item \code{add}: Add images

\item \code{average}: Average images

\item \code{mult}: Multiply images (pointwise)

\item \code{parmax}: Parallel max over images

\item \code{parmin}: Parallel min over images

\item \code{enorm}: Euclidean norm (i.e. sqrt(A^2 + B^2 + ...))
}}
\examples{
im1 <- as.cimg(function(x,y) x,100,100)
im2 <- as.cimg(function(x,y) y,100,100)
im3 <- as.cimg(function(x,y) cos(x/10),100,100)
l <- list(im1,im2,im3)
add(l) \%>\% plot #Add the images
average(l) \%>\% plot #Average the images
mult(l) \%>\% plot #Multiply
parmax(l) \%>\% plot #Parallel max
parmin(l) \%>\% plot #Parallel min
#Edge detection
imgradient(boats,"xy") \%>\% enorm \%>\% plot
#Pseudo-artistic effects
llply(seq(1,35,5),function(v) boxblur(boats,v)) \%>\% parmin \%>\% plot
llply(seq(1,35,5),function(v) boxblur(boats,v)) \%>\% average \%>\% plot
}
\author{
Simon Barthelme
}
\seealso{
imsplit,Reduce
}

