% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel_thresholding.R
\name{ThresholdML}
\alias{ThresholdML}
\title{Multilevel Thresholding}
\usage{
ThresholdML(im, k, thr = "fast", sn = 30, mcn = 100, limit = 100,
  intervalnumber = 1000, returnvalue = FALSE)
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{k}{level of thresholding. k is ignored when thr is a numeric vector.}

\item{thr}{thresholds, either numeric vector, or "fast", or "precise", or "manual".}

\item{sn}{population size. sn is ignored except when thr is "manual".}

\item{mcn}{maximum cycle number. mcn is ignored except when thr is "manual".}

\item{limit}{abandonment criteria. limit is ignored except when thr is "manual".}

\item{intervalnumber}{interval number of histogram. intervalnumber is ignored except when thr is "manual".}

\item{returnvalue}{if returnvalue is TRUE, returns threshold values. if FALSE, returns a grayscale image of class cimg.}
}
\value{
a grayscale image of class cimg or a numeric vector
}
\description{
Segments a grayscale image into several gray levels.
Multilevel thresholding selection based on the artificial bee colony algorithm is used when thr is not a numeric vector. Preset parameters for fast computing is used when thr is "fast". Preset parameters for precise computing is used when thr is "precise". You can tune the parameters if thr is "manual".
Also you can specify the values of thresholds by setting thr as a numeric vector.
}
\examples{
g <- grayscale(boats)
ThresholdML(g, k = 2) \%>\% plot
}
\references{
Ming-HuwiHorng (2011). Multilevel thresholding selection based on the artificial bee colony algorithm for image segmentation. Expert Systems with Applications.
}
\author{
Shota Ochi
}
