% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureEffect.R
\name{plot.FeatureEffect}
\alias{plot.FeatureEffect}
\title{Plot FeatureEffect}
\usage{
\method{plot}{FeatureEffect}(x, rug = TRUE, show.data = FALSE)
}
\arguments{
\item{x}{A FeatureEffect R6 object}

\item{rug}{[logical] Should a rug be plotted to indicate the feature distribution? The rug will be jittered a bit, so the location may not be exact, 
but it avoids overplotting.}

\item{show.data}{Should the data points be shown? Only affects 2D plots, and ignored for 1D plots, because rug has the same information.}
}
\value{
ggplot2 plot object
}
\description{
plot.FeatureEffect() plots the results of a FeatureEffect object.
}
\examples{
# We train a random forest on the Boston dataset:
if (require("randomForest")) {
data("Boston", package  = "MASS")
rf = randomForest(medv ~ ., data = Boston, ntree = 50)
mod = Predictor$new(rf, data = Boston)

# Compute the partial dependence for the first feature
eff = FeatureEffect$new(mod, feature = "crim")

# Plot the results directly
plot(eff)
}
}
\seealso{
\link{FeatureEffect}
}
