##' Class "ScoreFP"
##' This class represents the pathway fingerprint.
##'
##'
##' @name ScoreFP-class
##' @docType class
##' @slot Fingerprint pathway fingerprint
##' @slot FPType pathway fingerprint type
##' @exportClass ScoreFP
##' @author Yuanlong Hu


setClass("ScoreFP",
         slots = list(
           Fingerprint = "list",
           FPType = "character"
         ))



setClass("ScoreFP1",
         contains = "ScoreFP",
         slots = list(
           DiseaseBiomarker = "vector",
           DrugTarget = "list"
         )
)


setClass("ScoreFP2",
         contains = "ScoreFP",
         slots = list(
           DiseaseExpr = "data.frame",
           DiseaseDEG = "data.frame",
           DrugExpr = "list",
           DrugDEG = "list"
         )
)

##' Class "ScoreResult"
##'
##' This class represents the result of score.
##'
##'
##' @name ScoreResult-class
##' @docType class
##' @slot ScoreResult all score reslut.
##' @slot adj distribution data
##' @exportClass ScoreResult
##' @author Yuanlong Hu

setClass("ScoreResult",
         slots = list(
           ScoreResult = "data.frame",
           adj = "list"
         )
)

setClass("ScoreResultFP",
         contains = "ScoreResult",
         slots = list(
           Fingerprint = "ScoreFP"
         )
)


setClass("ScoreResultNet",
         contains = "ScoreResult",
         slots = list(
           DiseaseNetwork = "data.frame",
           Tar = "list"
         )
)
