% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_biodescr.R
\name{extr_biodescr,BasicData-method}
\alias{extr_biodescr,BasicData-method}
\title{Extract Biological descriptor}
\usage{
\S4method{extr_biodescr}{BasicData}(
  BasicData,
  geneset = c("kegg", "mkegg", "go", "wp"),
  arguments = list(minGSSize = 5, maxGSSize = 500, pvalue = 0.05, qvalue = 0.1),
  ref_type = "drug",
  ref = NULL,
  to_ENTREZID = TRUE
)
}
\arguments{
\item{BasicData}{BasicData object.}

\item{geneset}{Charactor vector, one of "kegg"(KEGG), "mkegg"(KEGG Module), "go"(GO-BP), and "wp"(WikiPathways); a data frame and list.}

\item{arguments}{A list of the arguments of \code{clusterProfiler}, including \code{minGSSize}, \code{maxGSSize}, \code{pvalue}, and \code{qvalue}.}

\item{ref_type}{Charactor vector, one of "drug", "herb", "compound" or "target", defaults to "drug".}

\item{ref}{Charactor vector, reference drug, herb, compound or target, defaults to \code{NULL}.}

\item{to_ENTREZID}{Logical, whether to translate to ENTREZID from SYMBOL, defaults to TRUE.}
}
\value{
A BioDescr object.
}
\description{
Extract Biological descriptor
}
\examples{
\dontrun{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
BasicData <- CreateBasicData(drug_herb, herb_compound, compound_target, diseasenet = disease)
biodescr <- extr_biodescr(BasicData, geneset= "kegg")
}
}
