% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis_immunr_kmer_profile_main}
\alias{vis_immunr_kmer_profile_main}
\title{Visualise kmer profiles}
\usage{
vis_immunr_kmer_profile_main(.data, .plot, ...)
}
\arguments{
\item{.data}{Kmer data, an output from \link{kmer_profile}.}

\item{.plot}{String specifying the plot type:

- "seqlogo" for traditional sequence logo plots using \link{vis_seqlogo};

- "textlogo" for modified approach to sequence logo plots via text labels using \link{vis_textlogo};}

\item{...}{Other arguments passed to \link{vis_textlogo} or \link{vis_seqlogo}, depending
on the ".plot" argument.}
}
\value{
A ggplot2 object.
}
\description{
Visualise kmer profiles
}
\examples{
data(immdata)
getKmers(immdata$data[[1]], 5) \%>\%
  kmer_profile() \%>\%
  vis("seqlogo")
}
\concept{kmers}
