% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied_odds.R
\name{implied_odds}
\alias{implied_odds}
\title{Implied odds with added margin from probabilities.}
\usage{
implied_odds(
  probabilities,
  method = "basic",
  margin = 0,
  grossmargin = NULL,
  normalize = TRUE
)
}
\arguments{
\item{probabilities}{A matrix or numeric of probabilities, where each column is an outcome.}

\item{method}{A string giving the method to use. Valid methods are 'basic', 'shin', 'bb', 'wpo', 'or', 'power' or 'additive'.}

\item{margin}{numeric. How large margin (aka overround) should be added to the probabilities.}

\item{grossmargin}{Numeric. Must be 0 or greater. See the details.}

\item{normalize}{Logical. If TRUE (default), scale the input probabilites to sum to 1.}
}
\value{
A named list. The first component is named 'odds' and contain a matrix of
implied odds. The second depends on the method used to compute the probabilities.
}
\description{
This functions converts probabilities to odds in decimal format, while adding overround.
The function does the inverse of what the function \code{\link{implied_probabilities}} does.
}
