% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_impala.R
\name{dbExecute,src_impala,character-method}
\alias{dbExecute,src_impala,character-method}
\title{Execute an Impala statement that returns no result}
\usage{
\S4method{dbExecute}{src_impala,character}(conn, statement, ...)
}
\arguments{
\item{conn}{object with class class \code{src_impala}}

\item{statement}{a character string containing SQL}

\item{...}{other arguments passed on to methods}
}
\value{
Depending on the package used to connect to Impala, either a scalar
  numeric that specifies the number of rows affected by the statement, or
  \code{NULL}
}
\description{
Executes an Impala statement that returns no result.
}
\note{
This method is for statements that return no result, such as data
  definition or data manipulation statements. Use
  \code{\link[=dbGetQuery,src_impala,character-method]{dbGetQuery()}} for
  \code{SELECT} queries.
}
\examples{
\dontrun{
dbExecute(impala, "INVALIDATE METADATA")}
}
