% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compute.R
\name{compute}
\alias{compute}
\title{Compute the missing values to later impute them in another dataset}
\usage{
compute(data, method = "median/mode", ...)
}
\arguments{
\item{data}{A data frame with dummies or numeric variables. Categorical variables (i.e., non-dummy / indicator) variables work up to a certain number but are not recommended.}

\item{method}{Either "median/mode" or "randomForest"}

\item{...}{additional arguments for \code{randomForest}}
}
\value{
Values or models used for imputation
}
\description{
When the median/mode method is used: character vectors and factors are imputed with the mode. Numeric and integer vectors are imputed with the median.
When the random forest method is used predictors are first imputed with the mean/median and each variable is then predicted and imputed with that value.
For predictive contexts there is a \code{compute} and an \code{impute} function. The former is used on a training set to learn the values (or random forest models) to impute (used to predict).
The latter is used on both the training and new data to impute the values (or deploy the models) learned by the \code{compute} function.
}
\examples{
#Example:
#create some data
data <- data.frame(V1=as.factor(c('yes','no','no',NA,'yes','yes','yes')),
                  V2=as.character(c(1,2,3,4,4,4,NA)),
                  V3=c(1:6,NA),V4=as.numeric(c(1:6,NA)))
#demonstrate function
object <- compute(data,method="randomForest")
object <- compute(data,method="median/mode")

impute(data)
impute(data,object=compute(data, method="randomForest"))
impute(data,method="randomForest")
}
\author{
Matthijs Meire, Michel Ballings, Dirk Van den Poel, Maintainer: \email{Matthijs.Meire@UGent.be}
}
\seealso{
\code{\link{impute}}
}

