% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimals.R
\name{getNDecimals}
\alias{getNDecimals}
\title{Get number of decimals for a specific vector.}
\usage{
getNDecimals(x, useRule = TRUE, rule = "1", useData = TRUE)
}
\arguments{
\item{x}{Numeric vector.}

\item{useRule}{Logical (TRUE by default), should the \code{rule} be applied?}

\item{rule}{Character vector with rule to use to derive 
the number of parameters.
Currently only: '1' is implemented.
\itemize{
\item{'1': }{standard rule for the number of 
decimals for individual values for a 
continuous variable:
\itemize{
\item{value < 1 ('very small values'): }{3}
\item{value < 10: }{2}
\item{value in [10, 1000[: }{1}
\item{value >= 1000: }{0}
}
}
}}

\item{useData}{Logical (TRUE by default), should the number of decimals
be extracted based on the input data \code{x}?}
}
\value{
Numeric vector of same length than \code{x}
with the number of decimals.
}
\description{
The number of decimals is extracted either:
\itemize{
\item{from specific implemented rule :}{
see \code{\link{getNDecimalsRule}} for further details}
\item{from the data itself: }{
see \code{\link{getNDecimalsData}} for further details
}
\item{both criterias: }{in this case the minimum of 
the number of decimals for both criterias is used}
}
}
\examples{
x <- c(0.99, 5.679, 50.45, 1450)
# extract number of decimals based on data:
getNDecimals(x, useRule = FALSE, useData = TRUE)
# extract number of decimals based on pre-defined rule:
getNDecimals(x, useRule = TRUE, useData = FALSE)
# extract number of decimals based on both rules
# minimum of both is used (by default)
getNDecimals(x, useRule = TRUE, useData = TRUE)
}
\seealso{
Other decimals: 
\code{\link{formatPercentage}()},
\code{\link{getMaxNDecimalsData}()},
\code{\link{getMaxNDecimals}()},
\code{\link{getNDecimalsData}()}
}
\author{
Laure Cougnaud
}
\concept{decimals}
