% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch_case.R
\name{switch_case}
\alias{switch_case}
\title{Switch-style recoding of values}
\usage{
switch_case(x, ..., preserve = FALSE, default = NA)
}
\arguments{
\item{x}{A vector}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas.
Elements of \code{x} that match the left hand side (LHS) will be replaced with
the value in the right hand side (RHS).

The LHS must evaluate to an atomic vector.

The RHS must be of length one.

\code{NULL} inputs are ignored.}

\item{preserve}{If \code{TRUE}, unmatched elements of \code{x} will be returned
unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of \code{x} will be replaced with \code{default}.
Defaults to \code{FALSE}.}

\item{default}{If \code{preserve} is \code{FALSE}, a value to replace unmatched
elements of \code{x}.
Defaults to \code{NA}.}
}
\value{
A vector of the same length as \code{x}.
}
\description{
Switch-style recoding of values
}
\examples{
parties <- sample(c("d", "r", "i", "g", "l"), 20, replace = TRUE)

switch_case(
  parties,
  "d" ~ "Democrat",
  "r" ~ "Republican",
  "i" ~ "Independent",
  "g" ~ "Green",
  "l" ~ "Libertarian"
)

parties \%>\%
  switch_case(
    "d" ~ "Democrat",
    "r" ~ "Republican",
    "i" ~ "Independent",
    "g" ~ "Green",
    "l" ~ "Libertarian"
  )

parties \%>\%
  switch_case(
    "d" ~ "Democrat",
    "r" ~ "Republican",
    c("i", "g", "l") ~ "Other"
  )

parties \%>\%
  switch_case(
    "d" ~ "Democrat",
    "r" ~ "Republican",
    default = "Other"
  )

parties \%>\%
  switch_case(
    "d" ~ "Democrat",
    "r" ~ "Republican",
    preserve = FALSE
  )

parties \%>\%
  switch_case(
    "d" ~ "Democrat",
    "r" ~ "Republican",
    preserve = TRUE
  )
}
\seealso{
\code{\link[=in_case]{in_case()}}, a pipeable alternative to \code{\link[dplyr:case_when]{dplyr::case_when()}}

\code{\link[=if_case]{if_case()}}, a pipeable alternative to \code{\link[dplyr:if_else]{dplyr::if_else()}}

\code{\link[=switch]{switch()}}, which inspired this function
}
