% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tract_geom.r
\name{get_tract_geom}
\alias{get_tract_geom}
\title{Get census tract boundary geometries}
\usage{
get_tract_geom(year, cache = TRUE, cache_dir = tempdir())
}
\arguments{
\item{year}{Numeric. Year of the census tract boundaries to retrieve (2015-2022)}

\item{cache}{Logical indicating whether to cache the extracted data. Default is TRUE.
Cached data is stored uncompressed for faster access.}

\item{cache_dir}{Character string specifying the cache directory. Default is tempdir().}
}
\value{
An sf object containing census tract boundaries with the following columns:
\itemize{
\item year: The reference year
\item tract_code: Census tract identifier
\item municipality: Municipality name
\item province: Province name
\item geometry: Census tract boundary geometry
}
}
\description{
Downloads and extracts census tract boundary files from the ineAtlas repository,
returning an sf object with the geometries for the specified year.
}
\examples{
\donttest{
# Get census tract boundaries for 2020
tracts_2020 <- get_tract_geom(2020)

# Get boundaries without caching
tracts_2019 <- get_tract_geom(2019, cache = FALSE)
}
}
